/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import java.util.Arrays;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.misc.ImplCommonOps_DSCC;
import org.ejml.sparse.csc.mult.ImplSparseSparseMult_DSCC;

public class CommonOps_DSCC {
    public static boolean checkIndicesSorted(DMatrixSparseCSC A) {
        for (int j = 0; j < A.numCols; ++j) {
            int idx0 = A.col_idx[j];
            int idx1 = A.col_idx[j + 1];
            if (idx0 != idx1 && A.nz_rows[idx0] >= A.numRows) {
                return false;
            }
            for (int i = idx0 + 1; i < idx1; ++i) {
                int row = A.nz_rows[i];
                if (A.nz_rows[i - 1] >= row) {
                    return false;
                }
                if (row < A.numRows) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkSortedFlag(DMatrixSparseCSC A) {
        if (A.indicesSorted) {
            return CommonOps_DSCC.checkIndicesSorted(A);
        }
        return true;
    }

    public static void transpose(DMatrixSparseCSC a, DMatrixSparseCSC a_t, int[] work) {
        if (a_t.numRows != a.numCols || a_t.numCols != a.numRows) {
            throw new IllegalArgumentException("Unexpected shape for transpose matrix");
        }
        a_t.growMaxLength(a.nz_length, false);
        a_t.nz_length = a.nz_length;
        ImplCommonOps_DSCC.transpose(a, a_t, work);
    }

    public static void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C) {
        CommonOps_DSCC.mult(A, B, C, null, null);
    }

    public static void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, int[] workA, double[] workB) {
        if (A.numRows != C.numRows || B.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplSparseSparseMult_DSCC.mult(A, B, C, workA, workB);
    }

    public static void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        if (A.numRows != C.numRows || B.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplSparseSparseMult_DSCC.mult(A, B, C);
    }

    public static void add(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC B, DMatrixSparseCSC C, int[] work0, double[] work1) {
        if (A.numRows != B.numRows || A.numCols != B.numCols || A.numRows != C.numRows || A.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplCommonOps_DSCC.add(alpha, A, beta, B, C, work0, work1);
    }

    public static DMatrixSparseCSC identity(int length) {
        return CommonOps_DSCC.identity(length, length);
    }

    public static DMatrixSparseCSC identity(int numRows, int numCols) {
        int i;
        int min = Math.min(numRows, numCols);
        DMatrixSparseCSC A = new DMatrixSparseCSC(numRows, numCols, min);
        Arrays.fill(A.nz_values, 0, min, 1.0);
        for (i = 1; i <= min; ++i) {
            A.col_idx[i] = i;
            A.nz_rows[i - 1] = i - 1;
        }
        for (i = min + 1; i <= numCols; ++i) {
            A.col_idx[i] = min;
        }
        return A;
    }

    public static void scale(double scalar, DMatrixSparseCSC A, DMatrixSparseCSC B) {
        if (A.numRows != B.numRows || A.numCols != B.numCols) {
            throw new IllegalArgumentException("Unexpected shape for transpose matrix");
        }
        B.copyStructure(A);
        for (int i = 0; i < A.nz_length; ++i) {
            B.nz_values[i] = A.nz_values[i] * scalar;
        }
    }

    public static void divide(DMatrixSparseCSC A, double scalar, DMatrixSparseCSC B) {
        if (A.numRows != B.numRows || A.numCols != B.numCols) {
            throw new IllegalArgumentException("Unexpected shape for transpose matrix");
        }
        B.copyStructure(A);
        for (int i = 0; i < A.nz_length; ++i) {
            B.nz_values[i] = A.nz_values[i] / scalar;
        }
    }

    public static double elementMinAbs(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double min = A.isFull() ? Math.abs(A.nz_values[0]) : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = Math.abs(A.nz_values[i]);
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double elementMaxAbs(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double max = A.isFull() ? Math.abs(A.nz_values[0]) : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = Math.abs(A.nz_values[i]);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementMin(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double min = A.isFull() ? A.nz_values[0] : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = A.nz_values[i];
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double elementMax(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double max = A.isFull() ? A.nz_values[0] : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = A.nz_values[i];
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static DMatrixSparseCSC diag(double ... values) {
        int N = values.length;
        DMatrixSparseCSC A = new DMatrixSparseCSC(N, N, N);
        for (int i = 0; i < N; ++i) {
            A.col_idx[i + 1] = i + 1;
            A.nz_rows[i] = i;
            A.nz_values[i] = values[i];
        }
        return A;
    }

    public static DMatrixSparseCSC permutationMatrix(int[] p, DMatrixSparseCSC P) {
        int N = p.length;
        if (P == null) {
            P = new DMatrixSparseCSC(N, N, N);
        } else {
            P.reshape(N, N, N);
        }
        P.indicesSorted = true;
        for (int i = 0; i < N; ++i) {
            P.col_idx[i + 1] = i + 1;
            P.nz_rows[p[i]] = i;
            P.nz_values[i] = 1.0;
        }
        return P;
    }

    public static void permutationVector(DMatrixSparseCSC P, int[] vector) {
        if (P.numCols != P.numRows) {
            throw new IllegalArgumentException("Expected a square matrix");
        }
        if (P.nz_length != P.numCols) {
            throw new IllegalArgumentException("Expected N non-zero elements in permutation matrix");
        }
        if (vector.length < P.numCols) {
            throw new IllegalArgumentException("vector is too short");
        }
        int M = P.numCols;
        for (int i = 0; i < M; ++i) {
            if (P.col_idx[i + 1] != i + 1) {
                throw new IllegalArgumentException("Unexpected number of elements in a column");
            }
            vector[P.nz_rows[i]] = i;
        }
    }

    public static void permutationInverse(int[] original, int[] inverse) {
        for (int i = 0; i < original.length; ++i) {
            inverse[original[i]] = i;
        }
    }

    public static void permuteRowInv(int[] permInv, DMatrixSparseCSC input, DMatrixSparseCSC output) {
        if (input.numRows != permInv.length) {
            throw new IllegalArgumentException("Number of rows in input must match length of permutation vector");
        }
        output.reshape(input.numRows, input.numCols, input.nz_length);
        output.indicesSorted = false;
        System.arraycopy(input.nz_values, 0, output.nz_values, 0, input.nz_length);
        System.arraycopy(input.col_idx, 0, output.col_idx, 0, input.numCols + 1);
        int M = permInv.length;
        int idx0 = 0;
        for (int i = 0; i < M; ++i) {
            int idx1 = output.col_idx[i + 1];
            for (int j = idx0; j < idx1; ++j) {
                output.nz_rows[j] = permInv[input.nz_rows[j]];
            }
            idx0 = idx1;
        }
    }

    public static void permute(int[] permRowInv, DMatrixSparseCSC input, int[] permCol, DMatrixSparseCSC output) {
        if (input.numRows != permRowInv.length) {
            throw new IllegalArgumentException("Number of column in input must match length of rowInv");
        }
        if (input.numCols != permCol.length) {
            throw new IllegalArgumentException("Number of rows in input must match length of colInv");
        }
        output.reshape(input.numRows, input.numCols, input.nz_length);
        output.indicesSorted = false;
        output.col_idx[0] = 0;
        int N = input.numCols;
        int outputNZ = 0;
        for (int i = 0; i < N; ++i) {
            int inputCol = permCol[i];
            int inputNZ = input.col_idx[inputCol];
            int total = input.col_idx[inputCol + 1] - inputNZ;
            output.col_idx[i + 1] = output.col_idx[i] + total;
            for (int j = 0; j < total; ++j) {
                output.nz_rows[outputNZ] = permRowInv[input.nz_rows[inputNZ]];
                output.nz_values[outputNZ++] = input.nz_values[inputNZ++];
            }
        }
    }
}

