/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheConfigurationBuilder;
import org.ehcache.config.Configuration;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionPrioritizer;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePoolsBuilder;
import org.ehcache.config.SerializerConfiguration;
import org.ehcache.config.copy.CopierConfiguration;
import org.ehcache.config.copy.DefaultCopierConfiguration;
import org.ehcache.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.config.event.CacheEventDispatcherFactoryConfiguration;
import org.ehcache.config.event.CacheEventListenerConfigurationBuilder;
import org.ehcache.config.executor.PooledExecutionServiceConfiguration;
import org.ehcache.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.config.loaderwriter.writebehind.WriteBehindProviderConfiguration;
import org.ehcache.config.persistence.CacheManagerPersistenceConfiguration;
import org.ehcache.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.config.store.disk.OffHeapDiskStoreProviderConfiguration;
import org.ehcache.config.writebehind.WriteBehindConfigurationBuilder;
import org.ehcache.config.xml.ConfigurationParser;
import org.ehcache.config.xml.model.CopierType;
import org.ehcache.config.xml.model.EventType;
import org.ehcache.config.xml.model.SerializerType;
import org.ehcache.config.xml.model.ServiceType;
import org.ehcache.config.xml.model.ThreadPoolReferenceType;
import org.ehcache.config.xml.model.ThreadPoolsType;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.expiry.Expiry;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.util.ClassLoading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlConfiguration
implements Configuration {
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfiguration.class);
    private final URL xml;
    private final ClassLoader classLoader;
    private final Map<String, ClassLoader> cacheClassLoaders;
    private final Collection<ServiceCreationConfiguration<?>> serviceConfigurations = new ArrayList();
    private final Map<String, CacheConfiguration<?, ?>> cacheConfigurations = new HashMap();
    private final Map<String, ConfigurationParser.CacheTemplate> templates = new HashMap<String, ConfigurationParser.CacheTemplate>();

    public XmlConfiguration(URL url) throws ClassNotFoundException, SAXException, InstantiationException, IllegalAccessException, IOException {
        this(url, ClassLoading.getDefaultClassLoader());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader) throws ClassNotFoundException, SAXException, InstantiationException, IOException, IllegalAccessException {
        this(url, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws ClassNotFoundException, SAXException, InstantiationException, IllegalAccessException, IOException {
        if (url == null) {
            throw new NullPointerException("The url can not be null");
        }
        if (classLoader == null) {
            throw new NullPointerException("The classLoader can not be null");
        }
        if (cacheClassLoaders == null) {
            throw new NullPointerException("The cacheClassLoaders map can not be null");
        }
        this.xml = url;
        this.classLoader = classLoader;
        this.cacheClassLoaders = new HashMap<String, ClassLoader>(cacheClassLoaders);
        this.parseConfiguration();
    }

    private void parseConfiguration() throws ClassNotFoundException, IOException, SAXException, InstantiationException, IllegalAccessException {
        DefaultSerializationProviderConfiguration configuration;
        LOGGER.info("Loading Ehcache XML configuration from {}.", (Object)this.xml.getPath());
        ConfigurationParser configurationParser = new ConfigurationParser(this.xml.toExternalForm(), CORE_SCHEMA_URL);
        ArrayList<Object> serviceConfigs = new ArrayList<Object>();
        for (ServiceType serviceType : configurationParser.getServiceElements()) {
            ServiceCreationConfiguration<?> serviceConfiguration = configurationParser.parseExtension((Element)serviceType.getAny());
            serviceConfigs.add(serviceConfiguration);
        }
        if (configurationParser.getDefaultSerializers() != null) {
            configuration = new DefaultSerializationProviderConfiguration();
            for (SerializerType.Serializer serializer : configurationParser.getDefaultSerializers().getSerializer()) {
                try {
                    configuration.addSerializerFor(XmlConfiguration.getClassForName(serializer.getType(), this.classLoader), XmlConfiguration.getClassForName(serializer.getValue(), this.classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            serviceConfigs.add(configuration);
        }
        if (configurationParser.getDefaultCopiers() != null) {
            configuration = new DefaultCopyProviderConfiguration();
            for (CopierType.Copier copier : configurationParser.getDefaultCopiers().getCopier()) {
                try {
                    configuration.addCopierFor(XmlConfiguration.getClassForName(copier.getType(), this.classLoader), XmlConfiguration.getClassForName(copier.getValue(), this.classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            serviceConfigs.add(configuration);
        }
        if (configurationParser.getPersistence() != null) {
            serviceConfigs.add(new CacheManagerPersistenceConfiguration(new File(configurationParser.getPersistence().getDirectory())));
        }
        if (configurationParser.getThreadPools() != null) {
            PooledExecutionServiceConfiguration poolsConfiguration = new PooledExecutionServiceConfiguration();
            for (ThreadPoolsType.ThreadPool pool : configurationParser.getThreadPools().getThreadPool()) {
                if (pool.isDefault()) {
                    poolsConfiguration.addDefaultPool(pool.getAlias(), pool.getMinSize().intValue(), pool.getMaxSize().intValue());
                    continue;
                }
                poolsConfiguration.addPool(pool.getAlias(), pool.getMinSize().intValue(), pool.getMaxSize().intValue());
            }
            serviceConfigs.add(poolsConfiguration);
        }
        if (configurationParser.getEventDispatch() != null) {
            ThreadPoolReferenceType eventDispatchThreading = configurationParser.getEventDispatch();
            serviceConfigs.add(new CacheEventDispatcherFactoryConfiguration(eventDispatchThreading.getThreadPool()));
        }
        if (configurationParser.getWriteBehind() != null) {
            ThreadPoolReferenceType writeBehindThreading = configurationParser.getWriteBehind();
            serviceConfigs.add(new WriteBehindProviderConfiguration(writeBehindThreading.getThreadPool()));
        }
        if (configurationParser.getDiskStore() != null) {
            ThreadPoolReferenceType diskStoreThreading = configurationParser.getDiskStore();
            serviceConfigs.add(new OffHeapDiskStoreProviderConfiguration(diskStoreThreading.getThreadPool()));
        }
        for (ServiceCreationConfiguration serviceConfiguration : Collections.unmodifiableList(serviceConfigs)) {
            this.serviceConfigurations.add(serviceConfiguration);
        }
        for (ConfigurationParser.CacheDefinition cacheDefinition : configurationParser.getCacheElements()) {
            CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder();
            String alias = cacheDefinition.id();
            ClassLoader cacheClassLoader = this.cacheClassLoaders.get(alias);
            if (cacheClassLoader != null) {
                builder = builder.withClassLoader(cacheClassLoader);
            }
            if (cacheClassLoader == null) {
                cacheClassLoader = this.classLoader != null ? this.classLoader : ClassLoading.getDefaultClassLoader();
            }
            Class<?> keyType = XmlConfiguration.getClassForName(cacheDefinition.keyType(), cacheClassLoader);
            Class<?> valueType = XmlConfiguration.getClassForName(cacheDefinition.valueType(), cacheClassLoader);
            if (cacheDefinition.keySerializer() != null) {
                Class<?> keySerializer = XmlConfiguration.getClassForName(cacheDefinition.keySerializer(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, SerializerConfiguration.Type.KEY));
            }
            if (cacheDefinition.keyCopier() != null) {
                Class<?> keyCopier = XmlConfiguration.getClassForName(cacheDefinition.keyCopier(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(keyCopier, CopierConfiguration.Type.KEY));
            }
            if (cacheDefinition.valueSerializer() != null) {
                Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheDefinition.valueSerializer(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, SerializerConfiguration.Type.VALUE));
            }
            if (cacheDefinition.valueCopier() != null) {
                Class<?> valueCopier = XmlConfiguration.getClassForName(cacheDefinition.valueCopier(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(valueCopier, CopierConfiguration.Type.VALUE));
            }
            EvictionVeto evictionVeto = XmlConfiguration.getInstanceOfName(cacheDefinition.evictionVeto(), cacheClassLoader, EvictionVeto.class);
            EvictionPrioritizer evictionPrioritizer = XmlConfiguration.getInstanceOfName(cacheDefinition.evictionPrioritizer(), cacheClassLoader, EvictionPrioritizer.class, Eviction.Prioritizer.class);
            ConfigurationParser.Expiry parsedExpiry = cacheDefinition.expiry();
            if (parsedExpiry != null) {
                builder = builder.withExpiry(this.getExpiry(cacheClassLoader, parsedExpiry));
            }
            ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            for (ResourcePool resourcePool : cacheDefinition.resourcePools()) {
                resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool.getType(), resourcePool.getSize(), resourcePool.getUnit(), resourcePool.isPersistent());
            }
            builder = builder.withResourcePools(resourcePoolsBuilder);
            ConfigurationParser.DiskStoreSettings parsedDiskStoreSettings = cacheDefinition.diskStoreSettings();
            if (parsedDiskStoreSettings != null) {
                builder = builder.add((ServiceConfiguration)new OffHeapDiskStoreConfiguration(parsedDiskStoreSettings.threadPool(), parsedDiskStoreSettings.writerConcurrency()));
            }
            for (ServiceConfiguration<?> serviceConfig : cacheDefinition.serviceConfigs()) {
                builder = builder.add(serviceConfig);
            }
            if (cacheDefinition.loaderWriter() != null) {
                Class<?> cacheLoaderWriterClass = XmlConfiguration.getClassForName(cacheDefinition.loaderWriter(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(cacheLoaderWriterClass, new Object[0]));
                if (cacheDefinition.writeBehind() != null) {
                    WriteBehindConfigurationBuilder.UnBatchedWriteBehindConfigurationBuilder writeBehindConfigurationBuilder;
                    ConfigurationParser.WriteBehind writeBehind = cacheDefinition.writeBehind();
                    if (writeBehind.batching() == null) {
                        writeBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newUnBatchedWriteBehindConfiguration();
                    } else {
                        ConfigurationParser.Batching batching = writeBehind.batching();
                        writeBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newBatchedWriteBehindConfiguration((long)batching.maxDelay(), (TimeUnit)batching.maxDelayUnit(), (int)batching.batchSize());
                        if (batching.isCoalesced()) {
                            writeBehindConfigurationBuilder = ((WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder)writeBehindConfigurationBuilder).enableCoalescing();
                        }
                    }
                    builder = builder.add((Builder)writeBehindConfigurationBuilder.useThreadPool(writeBehind.threadPool()).concurrencyLevel(writeBehind.concurrency()).queueSize(writeBehind.maxQueueSize()));
                }
            }
            if (cacheDefinition.listeners() != null) {
                for (ConfigurationParser.Listener listener : cacheDefinition.listeners()) {
                    Class<?> cacheEventListenerClass = XmlConfiguration.getClassForName(listener.className(), cacheClassLoader);
                    List<EventType> eventListToFireOn = listener.fireOn();
                    HashSet<org.ehcache.event.EventType> eventSetToFireOn = new HashSet<org.ehcache.event.EventType>();
                    block20: for (EventType events : eventListToFireOn) {
                        switch (events) {
                            case CREATED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.CREATED);
                                continue block20;
                            }
                            case EVICTED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.EVICTED);
                                continue block20;
                            }
                            case EXPIRED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.EXPIRED);
                                continue block20;
                            }
                            case UPDATED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.UPDATED);
                                continue block20;
                            }
                            case REMOVED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.REMOVED);
                                continue block20;
                            }
                        }
                        throw new IllegalArgumentException("Invalid Event Type provided");
                    }
                    CacheEventListenerConfigurationBuilder listenerBuilder = CacheEventListenerConfigurationBuilder.newEventListenerConfiguration(cacheEventListenerClass, eventSetToFireOn).firingMode(EventFiring.valueOf((String)listener.eventFiring().value())).eventOrdering(EventOrdering.valueOf((String)listener.eventOrdering().value()));
                    builder = builder.add((Builder)listenerBuilder);
                }
            }
            CacheConfiguration config = builder.buildConfig(keyType, valueType, evictionVeto, evictionPrioritizer);
            this.cacheConfigurations.put(alias, config);
        }
        this.templates.putAll(configurationParser.getTemplates());
    }

    private Expiry<? super Object, ? super Object> getExpiry(ClassLoader cacheClassLoader, ConfigurationParser.Expiry parsedExpiry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Expiry expiry = parsedExpiry.isUserDef() ? XmlConfiguration.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, Expiry.class) : (parsedExpiry.isTTL() ? Expirations.timeToLiveExpiration((Duration)new Duration(parsedExpiry.value(), parsedExpiry.unit())) : (parsedExpiry.isTTI() ? Expirations.timeToIdleExpiration((Duration)new Duration(parsedExpiry.value(), parsedExpiry.unit())) : Expirations.noExpiration()));
        return expiry;
    }

    private static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (name == null) {
            return null;
        }
        Class<?> klazz = XmlConfiguration.getClassForName(name, classLoader);
        return klazz.asSubclass(type).newInstance();
    }

    private static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type, Class<? extends Enum> shortcutValues) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (name == null) {
            return null;
        }
        try {
            return (T)Enum.valueOf(shortcutValues, name);
        }
        catch (IllegalArgumentException iae) {
            return XmlConfiguration.getInstanceOfName(name, classLoader, type);
        }
    }

    private static Class<?> getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    public URL getURL() {
        return this.xml;
    }

    public CacheConfigurationBuilder<Object, Object> newCacheConfigurationBuilderFromTemplate(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.newCacheConfigurationBuilderFromTemplate(name, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String loaderWriter;
        ConfigurationParser.CacheTemplate cacheTemplate = this.templates.get(name);
        if (cacheTemplate == null) {
            return null;
        }
        ClassLoader defaultClassLoader = ClassLoading.getDefaultClassLoader();
        Class<K> keyClass = XmlConfiguration.getClassForName(cacheTemplate.keyType(), defaultClassLoader);
        Class<V> valueClass = XmlConfiguration.getClassForName(cacheTemplate.valueType(), defaultClassLoader);
        if (keyType != null && cacheTemplate.keyType() != null && !keyClass.isAssignableFrom(keyType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares key type of " + cacheTemplate.keyType());
        }
        if (valueType != null && cacheTemplate.valueType() != null && !valueClass.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares value type of " + cacheTemplate.valueType());
        }
        CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder();
        builder = builder.usingEvictionPrioritizer(XmlConfiguration.getInstanceOfName(cacheTemplate.evictionPrioritizer(), defaultClassLoader, EvictionPrioritizer.class, Eviction.Prioritizer.class)).evictionVeto(XmlConfiguration.getInstanceOfName(cacheTemplate.evictionVeto(), defaultClassLoader, EvictionVeto.class));
        ConfigurationParser.Expiry parsedExpiry = cacheTemplate.expiry();
        if (parsedExpiry != null) {
            builder = builder.withExpiry(this.getExpiry(defaultClassLoader, parsedExpiry));
        }
        if (cacheTemplate.keySerializer() != null) {
            Class<?> keySerializer = XmlConfiguration.getClassForName(cacheTemplate.keySerializer(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, SerializerConfiguration.Type.KEY));
        }
        if (cacheTemplate.keyCopier() != null) {
            Class<?> keyCopier = XmlConfiguration.getClassForName(cacheTemplate.keyCopier(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(keyCopier, CopierConfiguration.Type.KEY));
        }
        if (cacheTemplate.valueSerializer() != null) {
            Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheTemplate.valueSerializer(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, SerializerConfiguration.Type.VALUE));
        }
        if (cacheTemplate.valueCopier() != null) {
            Class<?> valueCopier = XmlConfiguration.getClassForName(cacheTemplate.valueCopier(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(valueCopier, CopierConfiguration.Type.VALUE));
        }
        if ((loaderWriter = cacheTemplate.loaderWriter()) != null) {
            Class<?> cacheLoaderWriterClass = XmlConfiguration.getClassForName(loaderWriter, defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(cacheLoaderWriterClass, new Object[0]));
            if (cacheTemplate.writeBehind() != null) {
                void var13_16;
                ConfigurationParser.WriteBehind writeBehind = cacheTemplate.writeBehind();
                if (writeBehind.batching() == null) {
                    WriteBehindConfigurationBuilder.UnBatchedWriteBehindConfigurationBuilder unBatchedWriteBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newUnBatchedWriteBehindConfiguration();
                } else {
                    ConfigurationParser.Batching batching = writeBehind.batching();
                    WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder batchedWriteBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newBatchedWriteBehindConfiguration((long)batching.maxDelay(), (TimeUnit)batching.maxDelayUnit(), (int)batching.batchSize());
                    if (batching.isCoalesced()) {
                        WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder batchedWriteBehindConfigurationBuilder2 = batchedWriteBehindConfigurationBuilder.enableCoalescing();
                    }
                }
                builder = builder.add((Builder)var13_16.concurrencyLevel(writeBehind.concurrency()).queueSize(writeBehind.maxQueueSize()));
            }
        }
        if (cacheTemplate.listeners() != null) {
            for (ConfigurationParser.Listener listener : cacheTemplate.listeners()) {
                Class<?> clazz = XmlConfiguration.getClassForName(listener.className(), defaultClassLoader);
                List<EventType> eventListToFireOn = listener.fireOn();
                HashSet<org.ehcache.event.EventType> eventSetToFireOn = new HashSet<org.ehcache.event.EventType>();
                block8: for (EventType events : eventListToFireOn) {
                    switch (events) {
                        case CREATED: {
                            eventSetToFireOn.add(org.ehcache.event.EventType.CREATED);
                            continue block8;
                        }
                        case EVICTED: {
                            eventSetToFireOn.add(org.ehcache.event.EventType.EVICTED);
                            continue block8;
                        }
                        case EXPIRED: {
                            eventSetToFireOn.add(org.ehcache.event.EventType.EXPIRED);
                            continue block8;
                        }
                        case UPDATED: {
                            eventSetToFireOn.add(org.ehcache.event.EventType.UPDATED);
                            continue block8;
                        }
                        case REMOVED: {
                            eventSetToFireOn.add(org.ehcache.event.EventType.REMOVED);
                            continue block8;
                        }
                    }
                    throw new IllegalArgumentException("Invalid Event Type provided");
                }
                CacheEventListenerConfigurationBuilder listenerBuilder = CacheEventListenerConfigurationBuilder.newEventListenerConfiguration(clazz, eventSetToFireOn).firingMode(EventFiring.valueOf((String)listener.eventFiring().value())).eventOrdering(EventOrdering.valueOf((String)listener.eventOrdering().value()));
                builder = builder.add((Builder)listenerBuilder);
            }
        }
        ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
        for (ResourcePool resourcePool : cacheTemplate.resourcePools()) {
            resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool.getType(), resourcePool.getSize(), resourcePool.getUnit(), resourcePool.isPersistent());
        }
        builder = builder.withResourcePools(resourcePoolsBuilder);
        for (ServiceConfiguration serviceConfiguration : cacheTemplate.serviceConfigs()) {
            builder = builder.add(serviceConfiguration);
        }
        return builder;
    }

    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public Collection<ServiceCreationConfiguration<?>> getServiceCreationConfigurations() {
        return this.serviceConfigurations;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

