/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheConfigurationBuilder;
import org.ehcache.config.Configuration;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionPrioritizer;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePoolsBuilder;
import org.ehcache.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.config.xml.ConfigurationParser;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.expiry.Expiry;
import org.ehcache.internal.store.heap.service.OnHeapStoreServiceConfig;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.util.ClassLoading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlConfiguration
implements Configuration {
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfiguration.class);
    private final URL xml;
    private final ClassLoader classLoader;
    private final Map<String, ClassLoader> cacheClassLoaders;
    private final Collection<ServiceConfiguration<?>> serviceConfigurations = new ArrayList();
    private final Map<String, CacheConfiguration<?, ?>> cacheConfigurations = new HashMap();
    private final Map<String, ConfigurationParser.CacheTemplate> templates = new HashMap<String, ConfigurationParser.CacheTemplate>();

    public XmlConfiguration(URL url) throws ClassNotFoundException, SAXException, InstantiationException, IllegalAccessException, IOException {
        this(url, null);
    }

    public XmlConfiguration(URL url, ClassLoader classLoader) throws ClassNotFoundException, SAXException, InstantiationException, IOException, IllegalAccessException {
        this(url, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws ClassNotFoundException, SAXException, InstantiationException, IllegalAccessException, IOException {
        this.xml = url;
        this.classLoader = classLoader;
        this.cacheClassLoaders = new HashMap<String, ClassLoader>(cacheClassLoaders);
        this.parseConfiguration();
    }

    private void parseConfiguration() throws ClassNotFoundException, IOException, SAXException, InstantiationException, IllegalAccessException {
        LOGGER.info("Loading Ehcache XML configuration from {}.", (Object)this.xml.getPath());
        ConfigurationParser configurationParser = new ConfigurationParser(this.xml.toExternalForm(), CORE_SCHEMA_URL);
        for (ServiceConfiguration<?> serviceConfiguration : configurationParser.getServiceConfigurations()) {
            this.serviceConfigurations.add(serviceConfiguration);
        }
        for (ConfigurationParser.CacheDefinition cacheDefinition : configurationParser.getCacheElements()) {
            CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder();
            String alias = cacheDefinition.id();
            ClassLoader cacheClassLoader = this.cacheClassLoaders.get(alias);
            if (cacheClassLoader != null) {
                builder = builder.withClassLoader(cacheClassLoader);
            }
            if (cacheClassLoader == null) {
                cacheClassLoader = this.classLoader != null ? this.classLoader : ClassLoading.getDefaultClassLoader();
            }
            Class<?> keyType = XmlConfiguration.getClassForName(cacheDefinition.keyType(), cacheClassLoader);
            Class<?> valueType = XmlConfiguration.getClassForName(cacheDefinition.valueType(), cacheClassLoader);
            EvictionVeto evictionVeto = XmlConfiguration.getInstanceOfName(cacheDefinition.evictionVeto(), cacheClassLoader, EvictionVeto.class);
            EvictionPrioritizer evictionPrioritizer = XmlConfiguration.getInstanceOfName(cacheDefinition.evictionPrioritizer(), cacheClassLoader, EvictionPrioritizer.class, Eviction.Prioritizer.class);
            ConfigurationParser.Expiry parsedExpiry = cacheDefinition.expiry();
            builder = builder.withExpiry(this.getExpiry(cacheClassLoader, parsedExpiry));
            ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            for (ResourcePool resourcePool : cacheDefinition.resourcePools()) {
                resourcePoolsBuilder.with(resourcePool.getType(), resourcePool.getSize(), resourcePool.getUnit());
            }
            builder.withResourcePools(resourcePoolsBuilder.build());
            for (ServiceConfiguration serviceConfiguration : cacheDefinition.serviceConfigs()) {
                builder = builder.addServiceConfig(serviceConfiguration);
            }
            if (cacheDefinition.loaderWriter() != null) {
                Class<?> cacheLoaderWriterClass = XmlConfiguration.getClassForName(cacheDefinition.loaderWriter(), cacheClassLoader);
                builder = builder.addServiceConfig((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(cacheLoaderWriterClass));
            }
            OnHeapStoreServiceConfig onHeapStoreServiceConfig = new OnHeapStoreServiceConfig();
            onHeapStoreServiceConfig.storeByValue(cacheDefinition.storeByValueOnHeap());
            builder.addServiceConfig((ServiceConfiguration)onHeapStoreServiceConfig);
            CacheConfiguration cacheConfiguration = builder.buildConfig(keyType, valueType, evictionVeto, evictionPrioritizer);
            this.cacheConfigurations.put(alias, cacheConfiguration);
        }
        this.templates.putAll(configurationParser.getTemplates());
    }

    private Expiry<? super Object, ? super Object> getExpiry(ClassLoader cacheClassLoader, ConfigurationParser.Expiry parsedExpiry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Expiry expiry = parsedExpiry.isUserDef() ? XmlConfiguration.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, Expiry.class) : (parsedExpiry.isTTL() ? Expirations.timeToLiveExpiration((Duration)new Duration(parsedExpiry.value(), parsedExpiry.unit())) : (parsedExpiry.isTTI() ? Expirations.timeToIdleExpiration((Duration)new Duration(parsedExpiry.value(), parsedExpiry.unit())) : Expirations.noExpiration()));
        return expiry;
    }

    private static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (name == null) {
            return null;
        }
        Class<?> klazz = XmlConfiguration.getClassForName(name, classLoader);
        return klazz.asSubclass(type).newInstance();
    }

    private static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type, Class<? extends Enum> shortcutValues) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (name == null) {
            return null;
        }
        try {
            return (T)Enum.valueOf(shortcutValues, name);
        }
        catch (IllegalArgumentException iae) {
            return XmlConfiguration.getInstanceOfName(name, classLoader, type);
        }
    }

    private static Class<?> getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    public URL getURL() {
        return this.xml;
    }

    public CacheConfigurationBuilder<Object, Object> newCacheConfigurationBuilderFromTemplate(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.newCacheConfigurationBuilderFromTemplate(name, null, null);
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ConfigurationParser.CacheTemplate cacheTemplate = this.templates.get(name);
        if (cacheTemplate == null) {
            return null;
        }
        ClassLoader defaultClassLoader = ClassLoading.getDefaultClassLoader();
        Class<K> keyClass = XmlConfiguration.getClassForName(cacheTemplate.keyType(), defaultClassLoader);
        Class<V> valueClass = XmlConfiguration.getClassForName(cacheTemplate.valueType(), defaultClassLoader);
        if (keyType != null && cacheTemplate.keyType() != null && !keyClass.isAssignableFrom(keyType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares key type of " + cacheTemplate.keyType());
        }
        if (valueType != null && cacheTemplate.valueType() != null && !valueClass.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares value type of " + cacheTemplate.valueType());
        }
        CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder();
        ConfigurationParser.Expiry parsedExpiry = cacheTemplate.expiry();
        builder = builder.usingEvictionPrioritizer(XmlConfiguration.getInstanceOfName(cacheTemplate.evictionPrioritizer(), defaultClassLoader, EvictionPrioritizer.class, Eviction.Prioritizer.class)).evitionVeto(XmlConfiguration.getInstanceOfName(cacheTemplate.evictionVeto(), defaultClassLoader, EvictionVeto.class)).withExpiry(this.getExpiry(defaultClassLoader, parsedExpiry));
        String loaderWriter = cacheTemplate.loaderWriter();
        if (loaderWriter != null) {
            Class<?> cacheLoaderWriterClass = XmlConfiguration.getClassForName(loaderWriter, defaultClassLoader);
            builder = builder.addServiceConfig((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(cacheLoaderWriterClass));
        }
        ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
        for (ResourcePool resourcePool : cacheTemplate.resourcePools()) {
            resourcePoolsBuilder.with(resourcePool.getType(), resourcePool.getSize(), resourcePool.getUnit());
        }
        builder.withResourcePools(resourcePoolsBuilder.build());
        for (ServiceConfiguration serviceConfiguration : cacheTemplate.serviceConfigs()) {
            builder = builder.addServiceConfig(serviceConfiguration);
        }
        OnHeapStoreServiceConfig onHeapStoreServiceConfig = new OnHeapStoreServiceConfig();
        onHeapStoreServiceConfig.storeByValue(cacheTemplate.storeByValueOnHeap());
        builder.addServiceConfig((ServiceConfiguration)onHeapStoreServiceConfig);
        return builder;
    }

    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public Collection<ServiceConfiguration<?>> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

