/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.xml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.persistence.PersistenceConfiguration;
import org.ehcache.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.config.xml.JaxbHelper;
import org.ehcache.config.xml.XmlConfigurationParser;
import org.ehcache.config.xml.model.BaseCacheType;
import org.ehcache.config.xml.model.CacheIntegration;
import org.ehcache.config.xml.model.CacheTemplateType;
import org.ehcache.config.xml.model.CacheType;
import org.ehcache.config.xml.model.ConfigType;
import org.ehcache.config.xml.model.ExpiryType;
import org.ehcache.config.xml.model.PersistenceType;
import org.ehcache.config.xml.model.ResourceType;
import org.ehcache.config.xml.model.ResourcesType;
import org.ehcache.config.xml.model.SerializerType;
import org.ehcache.config.xml.model.ServiceType;
import org.ehcache.config.xml.model.TimeType;
import org.ehcache.internal.serialization.JavaSerializationProvider;
import org.ehcache.spi.service.LocalPersistenceService;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.util.ClassLoading;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ConfigurationParser {
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final Map<URI, XmlConfigurationParser<?>> xmlParsers = new HashMap();
    private final ConfigType config;

    public ConfigurationParser(String xml, URL ... sources) throws IOException, SAXException {
        DocumentBuilder domBuilder;
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        for (XmlConfigurationParser parser : ClassLoading.libraryServiceLoaderFor(XmlConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.xmlParsers.put(parser.getNamespace(), parser);
        }
        for (URL source : sources) {
            schemaSources.add(new StreamSource(source.openStream()));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        try {
            domBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        domBuilder.setErrorHandler(new FatalErrorHandler());
        Element config = domBuilder.parse(xml).getDocumentElement();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.ehcache.config.xml.model");
            Unmarshaller u = jc.createUnmarshaller();
            this.config = (ConfigType)u.unmarshal((Node)config, ConfigType.class).getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<ServiceConfiguration<?>> getServiceConfigurations() {
        ArrayList<Object> serviceConfigurations = new ArrayList<Object>();
        for (ServiceType serviceType : this.config.getService()) {
            if (serviceType.getSerializerDefault() != null) {
                serviceConfigurations.add(this.parseDefaultSerializerConfig(serviceType.getSerializerDefault()));
                continue;
            }
            if (serviceType.getPersistence() != null) {
                serviceConfigurations.add(this.parsePersistenceConfig(serviceType.getPersistence()));
                continue;
            }
            ServiceConfiguration<?> serviceConfiguration = this.parseExtension((Element)serviceType.getAny());
            serviceConfigurations.add(serviceConfiguration);
        }
        return Collections.unmodifiableList(serviceConfigurations);
    }

    private ServiceConfiguration<LocalPersistenceService> parsePersistenceConfig(PersistenceType persistence) {
        return new PersistenceConfiguration(new File(persistence.getDirectory()));
    }

    private ServiceConfiguration<JavaSerializationProvider> parseDefaultSerializerConfig(SerializerType serializerType) {
        DefaultSerializationProviderConfiguration configuration = new DefaultSerializationProviderConfiguration();
        for (SerializerType.Class clazz : serializerType.getClazz()) {
            String type = clazz.getType();
            DefaultSerializationProviderConfiguration.TypeSerializerConfig config = null;
            config = configuration.contains(type) ? configuration.getTypeSerializerConfig(type) : new DefaultSerializationProviderConfiguration.TypeSerializerConfig();
            this.addTypeSerializerMapping(config, clazz);
            configuration.addSerializer(type, config);
        }
        return configuration;
    }

    private void addTypeSerializerMapping(DefaultSerializationProviderConfiguration.TypeSerializerConfig config, SerializerType.Class clazz) {
        if (clazz.getCache() == null) {
            config.setSerializer(clazz.getValue());
        } else {
            config.addTypeSerializerMapping(clazz.getCache(), clazz.getValue());
        }
    }

    public Iterable<CacheDefinition> getCacheElements() {
        ArrayList<1> cacheCfgs = new ArrayList<1>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            final CacheType cacheType = (CacheType)baseCacheType;
            final BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(){

                @Override
                public String id() {
                    return cacheType.getAlias();
                }

                @Override
                public String keyType() {
                    BaseCacheType source;
                    int i$;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getKeyType()) == null; ++i$) {
                    }
                    if (value == null) {
                        arr$ = sources;
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "keyType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String valueType() {
                    BaseCacheType source;
                    int i$;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getValueType()) == null; ++i$) {
                    }
                    if (value == null) {
                        arr$ = sources;
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "valueType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String evictionVeto() {
                    BaseCacheType source;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getEvictionVeto()) == null; ++i$) {
                    }
                    return value;
                }

                @Override
                public String evictionPrioritizer() {
                    BaseCacheType source;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getEvictionPrioritizer()) == null; ++i$) {
                    }
                    return value;
                }

                @Override
                public Expiry expiry() {
                    BaseCacheType source;
                    ExpiryType value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getExpiry()) == null; ++i$) {
                    }
                    return new XmlExpiry(value);
                }

                @Override
                public boolean storeByValueOnHeap() {
                    BaseCacheType source;
                    Boolean value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).isStoreByValueOnHeap()) == null; ++i$) {
                    }
                    return value == null ? false : value;
                }

                @Override
                public String loaderWriter() {
                    String configClass = null;
                    for (BaseCacheType source : sources) {
                        CacheIntegration.Loaderwriter loaderWriter;
                        CacheIntegration integration = source.getIntegration();
                        CacheIntegration.Loaderwriter loaderwriter = loaderWriter = integration != null ? integration.getLoaderwriter() : null;
                        if (loaderWriter == null) continue;
                        configClass = loaderWriter.getClazz();
                        break;
                    }
                    return configClass;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (BaseCacheType source : sources) {
                        for (Object child : source.getAny()) {
                            configs.add(ConfigurationParser.this.parseExtension((Element)child));
                        }
                    }
                    return configs;
                }

                @Override
                public Iterable<ResourcePool> resourcePools() {
                    ArrayList<ResourcePool> resourcePools = new ArrayList<ResourcePool>();
                    for (BaseCacheType source : sources) {
                        ResourceType diskResource;
                        ResourceType offheapResource;
                        ResourceType directHeapResource = source.getHeap();
                        if (directHeapResource != null) {
                            resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, directHeapResource.getSize().longValue(), ConfigurationParser.this.parseUnit(directHeapResource)));
                            continue;
                        }
                        ResourcesType resources = source.getResources();
                        if (resources == null) continue;
                        ResourceType heapResource = resources.getHeap();
                        if (heapResource != null) {
                            resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, heapResource.getSize().longValue(), ConfigurationParser.this.parseUnit(heapResource)));
                        }
                        if ((offheapResource = resources.getOffheap()) != null) {
                            resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.OFFHEAP, offheapResource.getSize().longValue(), ConfigurationParser.this.parseUnit(offheapResource)));
                        }
                        if ((diskResource = resources.getDisk()) == null) continue;
                        resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.DISK, diskResource.getSize().longValue(), ConfigurationParser.this.parseUnit(diskResource)));
                    }
                    return resourcePools;
                }
            });
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    public Map<String, CacheTemplate> getTemplates() {
        HashMap<String, 2> templates = new HashMap<String, 2>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            final CacheTemplateType cacheTemplate = (CacheTemplateType)baseCacheType;
            templates.put(cacheTemplate.getName(), new CacheTemplate(){

                @Override
                public String keyType() {
                    String keyType = cacheTemplate.getKeyType();
                    if (keyType == null) {
                        keyType = JaxbHelper.findDefaultValue(cacheTemplate, "keyType");
                    }
                    return keyType;
                }

                @Override
                public String valueType() {
                    String valueType = cacheTemplate.getValueType();
                    if (valueType == null) {
                        valueType = JaxbHelper.findDefaultValue(cacheTemplate, "valueType");
                    }
                    return valueType;
                }

                @Override
                public String evictionVeto() {
                    return cacheTemplate.getEvictionVeto();
                }

                @Override
                public String evictionPrioritizer() {
                    return cacheTemplate.getEvictionPrioritizer();
                }

                @Override
                public Expiry expiry() {
                    return new XmlExpiry(cacheTemplate.getExpiry());
                }

                @Override
                public boolean storeByValueOnHeap() {
                    Boolean storeByValueOnHeap = cacheTemplate.isStoreByValueOnHeap();
                    return storeByValueOnHeap == null ? false : storeByValueOnHeap;
                }

                @Override
                public String loaderWriter() {
                    CacheIntegration integration = cacheTemplate.getIntegration();
                    CacheIntegration.Loaderwriter loaderWriter = integration != null ? integration.getLoaderwriter() : null;
                    return loaderWriter != null ? loaderWriter.getClazz() : null;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (Object child : cacheTemplate.getAny()) {
                        configs.add(ConfigurationParser.this.parseExtension((Element)child));
                    }
                    return configs;
                }

                @Override
                public Iterable<ResourcePool> resourcePools() {
                    ArrayList<ResourcePool> resourcePools = new ArrayList<ResourcePool>();
                    ResourceType directHeapResource = cacheTemplate.getHeap();
                    if (directHeapResource != null) {
                        resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, directHeapResource.getSize().longValue(), ConfigurationParser.this.parseUnit(directHeapResource)));
                    } else {
                        ResourcesType resources = cacheTemplate.getResources();
                        if (resources != null) {
                            ResourceType diskResource;
                            ResourceType offheapResource;
                            ResourceType heapResource = resources.getHeap();
                            if (heapResource != null) {
                                resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, heapResource.getSize().longValue(), ConfigurationParser.this.parseUnit(heapResource)));
                            }
                            if ((offheapResource = resources.getOffheap()) != null) {
                                resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.OFFHEAP, offheapResource.getSize().longValue(), ConfigurationParser.this.parseUnit(offheapResource)));
                            }
                            if ((diskResource = resources.getDisk()) != null) {
                                resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.DISK, diskResource.getSize().longValue(), ConfigurationParser.this.parseUnit(diskResource)));
                            }
                        }
                    }
                    return resourcePools;
                }
            });
        }
        return Collections.unmodifiableMap(templates);
    }

    private ResourceUnit parseUnit(ResourceType resourceType) {
        if (resourceType.getUnit().value().equalsIgnoreCase("entries")) {
            return EntryUnit.ENTRIES;
        }
        return MemoryUnit.valueOf((String)resourceType.getUnit().value().toUpperCase());
    }

    private ServiceConfiguration<?> parseExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        XmlConfigurationParser<?> xmlConfigurationParser = this.xmlParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parse(element);
    }

    private static class XmlExpiry
    implements Expiry {
        final ExpiryType type;

        private XmlExpiry(ExpiryType type) {
            this.type = type;
        }

        @Override
        public boolean isUserDef() {
            return this.type != null && this.type.getClazz() != null;
        }

        @Override
        public boolean isTTI() {
            return this.type != null && this.type.getTti() != null;
        }

        @Override
        public boolean isTTL() {
            return this.type != null && this.type.getTtl() != null;
        }

        @Override
        public String type() {
            return this.type.getClazz();
        }

        @Override
        public long value() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            return time == null ? 0L : time.getValue().longValue();
        }

        @Override
        public TimeUnit unit() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            if (time != null) {
                switch (time.getUnit()) {
                    case NANOS: {
                        return TimeUnit.NANOSECONDS;
                    }
                    case MICROS: {
                        return TimeUnit.MICROSECONDS;
                    }
                    case MILLIS: {
                        return TimeUnit.MILLISECONDS;
                    }
                    case SECONDS: {
                        return TimeUnit.SECONDS;
                    }
                    case MINUTES: {
                        return TimeUnit.MINUTES;
                    }
                    case HOURS: {
                        return TimeUnit.HOURS;
                    }
                    case DAYS: {
                        return TimeUnit.DAYS;
                    }
                }
            }
            return null;
        }
    }

    static interface Expiry {
        public boolean isUserDef();

        public boolean isTTI();

        public boolean isTTL();

        public String type();

        public long value();

        public TimeUnit unit();
    }

    static interface CacheDefinition
    extends CacheTemplate {
        public String id();
    }

    static interface CacheTemplate {
        public String keyType();

        public String valueType();

        public String evictionVeto();

        public String evictionPrioritizer();

        public Expiry expiry();

        public boolean storeByValueOnHeap();

        public String loaderWriter();

        public Iterable<ServiceConfiguration<?>> serviceConfigs();

        public Iterable<ResourcePool> resourcePools();
    }

    static class FatalErrorHandler
    implements ErrorHandler {
        FatalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static final class ResourcePoolImpl
    implements ResourcePool {
        private final org.ehcache.config.ResourceType type;
        private final long size;
        private final ResourceUnit unit;

        public ResourcePoolImpl(org.ehcache.config.ResourceType type, long size, ResourceUnit unit) {
            this.type = type;
            this.size = size;
            this.unit = unit;
        }

        public org.ehcache.config.ResourceType getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public ResourceUnit getUnit() {
            return this.unit;
        }
    }
}

