/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.clustered.server.management.ServerStoreBinding;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.Settings;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;
import org.terracotta.management.service.monitoring.registry.provider.AliasBinding;
import org.terracotta.management.service.monitoring.registry.provider.AliasBindingManagementProvider;

@Named(value="ServerStoreSettings")
@RequiredContext(value={@Named(value="consumerId"), @Named(value="type"), @Named(value="alias")})
class ServerStoreSettingsManagementProvider
extends AliasBindingManagementProvider<ServerStoreBinding> {
    private final String clusterTierManagerIdentifier;

    ServerStoreSettingsManagementProvider(String clusterTierManagerIdentifier) {
        super(ServerStoreBinding.class);
        this.clusterTierManagerIdentifier = clusterTierManagerIdentifier;
    }

    public Collection<Descriptor> getDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(super.getDescriptors());
        descriptors.add((Descriptor)new Settings().set("type", this.getCapabilityName()).set("clusterTierManager", this.clusterTierManagerIdentifier).set("time", (Number)System.currentTimeMillis()));
        return descriptors;
    }

    protected ExposedServerStoreBinding internalWrap(Context context, ServerStoreBinding managedObject) {
        return new ExposedServerStoreBinding(context, managedObject);
    }

    private static class ExposedServerStoreBinding
    extends AliasBindingManagementProvider.ExposedAliasBinding<ServerStoreBinding> {
        ExposedServerStoreBinding(Context context, ServerStoreBinding binding) {
            super(context.with("type", "ServerStore"), (AliasBinding)binding);
        }

        public Collection<? extends Descriptor> getDescriptors() {
            return Collections.singleton(this.getSettings());
        }

        Settings getSettings() {
            PoolAllocation poolAllocation = ((ServerStoreBinding)this.getBinding()).getValue().getStoreConfiguration().getPoolAllocation();
            Settings settings = new Settings((Map)this.getContext()).set("resourcePoolType", poolAllocation.getClass().getSimpleName().toLowerCase()).set("allocatedMemoryAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getAllocatedMemory()).set("tableCapacityAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getTableCapacity()).set("vitalMemoryAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getVitalMemory()).set("longSizeAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getSize()).set("dataAllocatedMemoryAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getDataAllocatedMemory()).set("dataOccupiedMemoryAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getDataOccupiedMemory()).set("dataSizeAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getDataSize()).set("dataVitalMemoryAtTime", (Number)((ServerStoreBinding)this.getBinding()).getValue().getDataVitalMemory());
            if (poolAllocation instanceof PoolAllocation.DedicatedPoolAllocation) {
                settings.set("resourcePoolDedicatedResourceName", ((PoolAllocation.DedicatedPoolAllocation)poolAllocation).getResourceName());
                settings.set("resourcePoolDedicatedSize", (Number)((PoolAllocation.DedicatedPoolAllocation)poolAllocation).getSize());
            } else if (poolAllocation instanceof PoolAllocation.SharedPoolAllocation) {
                settings.set("resourcePoolSharedPoolName", ((PoolAllocation.SharedPoolAllocation)poolAllocation).getResourcePoolName());
            }
            return settings;
        }
    }
}

