/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.cluster;

import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.ehcache.Cache;
import org.ehcache.StateTransitionException;
import org.ehcache.Status;
import org.ehcache.clustered.client.service.ClientEntityFactory;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.client.service.EntityService;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.internal.executor.ExecutorUtil;
import org.ehcache.management.CollectorService;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.cluster.ClusteringManagementService;
import org.ehcache.management.cluster.ClusteringManagementServiceConfiguration;
import org.ehcache.management.cluster.DefaultClusteringManagementServiceConfiguration;
import org.ehcache.management.cluster.LoggingExecutor;
import org.ehcache.management.registry.DefaultCollectorService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.management.entity.management.ManagementAgentConfig;
import org.terracotta.management.entity.management.ManagementAgentVersion;
import org.terracotta.management.entity.management.client.ManagementAgentEntity;
import org.terracotta.management.entity.management.client.ManagementAgentService;
import org.terracotta.management.model.notification.ContextualNotification;
import org.terracotta.management.model.stats.ContextualStatistics;
import org.terracotta.management.registry.ManagementRegistry;

@ServiceDependencies(value={CacheManagerProviderService.class, ExecutionService.class, TimeSourceService.class, ManagementRegistryService.class, EntityService.class, ClusteringService.class})
public class DefaultClusteringManagementService
implements ClusteringManagementService,
CacheManagerListener,
CollectorService.Collector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusteringManagementService.class);
    private final ClusteringManagementServiceConfiguration configuration;
    private volatile ManagementRegistryService managementRegistryService;
    private volatile CollectorService collectorService;
    private volatile ManagementAgentService managementAgentService;
    private volatile ClientEntityFactory<ManagementAgentEntity, ManagementAgentConfig> managementAgentEntityFactory;
    private volatile InternalCacheManager cacheManager;
    private volatile ExecutorService managementCallExecutor;
    private volatile ClusteringService clusteringService;

    public DefaultClusteringManagementService() {
        this(new DefaultClusteringManagementServiceConfiguration());
    }

    public DefaultClusteringManagementService(ClusteringManagementServiceConfiguration configuration) {
        this.configuration = configuration == null ? new DefaultClusteringManagementServiceConfiguration() : configuration;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.clusteringService = (ClusteringService)serviceProvider.getService(ClusteringService.class);
        this.managementRegistryService = (ManagementRegistryService)serviceProvider.getService(ManagementRegistryService.class);
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        this.managementCallExecutor = ((ExecutionService)serviceProvider.getService(ExecutionService.class)).getOrderedExecutor(this.configuration.getManagementCallExecutorAlias(), new ArrayBlockingQueue(this.configuration.getManagementCallQueueSize()));
        this.collectorService = new DefaultCollectorService(this);
        this.collectorService.start(serviceProvider);
        EntityService entityService = (EntityService)serviceProvider.getService(EntityService.class);
        this.managementAgentEntityFactory = entityService.newClientEntityFactory("ManagementAgent", ManagementAgentEntity.class, ManagementAgentVersion.LATEST.version(), (Object)new ManagementAgentConfig());
        this.cacheManager.registerListener((CacheManagerListener)this);
    }

    public void stop() {
        if (this.collectorService != null) {
            this.collectorService.stop();
        }
        ExecutorUtil.shutdownNow((ExecutorService)this.managementCallExecutor);
        if (this.managementAgentService != null) {
            this.managementAgentService.close();
            this.managementRegistryService = null;
        }
        this.managementAgentService = null;
        this.managementCallExecutor = null;
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
    }

    public void stateTransition(Status from, Status to) {
        switch (to) {
            case AVAILABLE: {
                ManagementAgentEntity managementAgentEntity;
                try {
                    managementAgentEntity = (ManagementAgentEntity)this.managementAgentEntityFactory.retrieve();
                }
                catch (EntityNotFoundException e) {
                    try {
                        this.managementAgentEntityFactory.create();
                    }
                    catch (EntityAlreadyExistsException ignored) {
                        // empty catch block
                    }
                    try {
                        managementAgentEntity = (ManagementAgentEntity)this.managementAgentEntityFactory.retrieve();
                    }
                    catch (EntityNotFoundException bigFailure) {
                        throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Entity " + ManagementAgentEntity.class.getSimpleName() + " cannot be retrieved even after being created.")))).initCause(bigFailure.getCause()));
                    }
                }
                this.managementAgentService = new ManagementAgentService(managementAgentEntity);
                this.managementAgentService.setOperationTimeout(this.configuration.getManagementCallTimeoutSec(), TimeUnit.SECONDS);
                this.managementAgentService.setManagementRegistry((ManagementRegistry)this.managementRegistryService);
                this.managementAgentService.setManagementCallExecutor((Executor)new LoggingExecutor(this.managementCallExecutor, LoggerFactory.getLogger((String)(this.getClass().getName() + ".managementCallExecutor"))));
                try {
                    this.managementAgentService.init();
                    this.managementAgentService.setTags(this.managementRegistryService.getConfiguration().getTags());
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new StateTransitionException((Throwable)e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                break;
            }
            case MAINTENANCE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + to));
            }
        }
    }

    @Override
    public void onNotification(ContextualNotification notification) {
        ManagementAgentService service = this.managementAgentService;
        if (service != null) {
            try {
                service.pushNotification(notification);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to push notification " + notification + ": " + e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Failed to push notification " + notification + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void onStatistics(Collection<ContextualStatistics> statistics) {
        ManagementAgentService service = this.managementAgentService;
        if (service != null) {
            try {
                service.pushStatistics(statistics);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to push statistics " + statistics + ": " + e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Failed to push statistics " + statistics + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

