/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.actions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.ehcache.management.providers.CacheBinding;
import org.terracotta.management.context.Context;
import org.terracotta.management.registry.action.Exposed;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.action.Named;

public class EhcacheActionWrapper
implements ExposedObject<CacheBinding> {
    private final CacheBinding managedObject;
    private final Context cacheContext;

    public EhcacheActionWrapper(Context cacheContext, CacheBinding managedObject) {
        this.cacheContext = cacheContext;
        this.managedObject = managedObject;
    }

    public ClassLoader getClassLoader() {
        return this.managedObject.getCache().getRuntimeConfiguration().getClassLoader();
    }

    public CacheBinding getTarget() {
        return this.managedObject;
    }

    public boolean matches(Context context) {
        return context.contains(this.cacheContext);
    }

    @Exposed
    public void clear() {
        this.managedObject.getCache().clear();
    }

    @Exposed
    public Object get(@Named(value="key") Object key) {
        Object convertedKey = EhcacheActionWrapper.convert(key, this.managedObject.getCache().getRuntimeConfiguration().getKeyType());
        return this.managedObject.getCache().get(convertedKey);
    }

    @Exposed
    public void remove(@Named(value="key") Object key) {
        Object convertedKey = EhcacheActionWrapper.convert(key, this.managedObject.getCache().getRuntimeConfiguration().getKeyType());
        this.managedObject.getCache().remove(convertedKey);
    }

    @Exposed
    public void put(@Named(value="key") Object key, @Named(value="value") Object value) {
        Object convertedKey = EhcacheActionWrapper.convert(key, this.managedObject.getCache().getRuntimeConfiguration().getKeyType());
        Object convertedValue = EhcacheActionWrapper.convert(value, this.managedObject.getCache().getRuntimeConfiguration().getValueType());
        this.managedObject.getCache().put(convertedKey, convertedValue);
    }

    private static Object convert(Object srcObj, Class<?> destClazz) {
        if (srcObj == null || destClazz.isInstance(srcObj)) {
            return srcObj;
        }
        try {
            Constructor<?> constructor = destClazz.getConstructor(srcObj.getClass());
            return constructor.newInstance(srcObj);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No conversion possible from " + srcObj.getClass().getName() + " to " + destClazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Conversion error from " + srcObj.getClass().getName() + " to " + destClazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

