/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.internal.executor.ExecutorUtil;
import org.ehcache.management.CollectorService;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.management.registry.EhcacheNotification;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.context.Context;
import org.terracotta.management.context.ContextContainer;
import org.terracotta.management.message.DefaultMessage;
import org.terracotta.management.message.Message;
import org.terracotta.management.notification.ContextualNotification;
import org.terracotta.management.registry.MessageConsumer;
import org.terracotta.management.registry.StatisticQuery;
import org.terracotta.management.stats.ContextualStatistics;

@ServiceDependencies(value={CacheManagerProviderService.class, ManagementRegistryService.class, ExecutionService.class, TimeSourceService.class})
public class DefaultCollectorService
implements CollectorService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCollectorService.class);
    private ScheduledFuture<?> task;
    private final ConcurrentMap<String, StatisticQuery.Builder> selectedStatsPerCapability = new ConcurrentHashMap<String, StatisticQuery.Builder>();
    private final MessageConsumer messageConsumer;
    private volatile TimeSource timeSource;
    private volatile ManagementRegistryService managementRegistry;
    private volatile ScheduledExecutorService scheduledExecutorService;
    private volatile InternalCacheManager cacheManager;
    private volatile ManagementRegistryServiceConfiguration configuration;

    public DefaultCollectorService(MessageConsumer messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    public synchronized void start(ServiceProvider<Service> serviceProvider) {
        this.timeSource = ((TimeSourceService)serviceProvider.getService(TimeSourceService.class)).getTimeSource();
        this.managementRegistry = (ManagementRegistryService)serviceProvider.getService(ManagementRegistryService.class);
        this.configuration = this.managementRegistry.getConfiguration();
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        this.scheduledExecutorService = ((ExecutionService)serviceProvider.getService(ExecutionService.class)).getScheduledExecutor(this.configuration.getCollectorExecutorAlias());
        this.cacheManager.registerListener((CacheManagerListener)this);
    }

    public synchronized void stop() {
        this.stopStatisticCollector();
        ExecutorUtil.shutdownNow((ExecutorService)this.scheduledExecutorService);
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        this.messageConsumer.accept((Message)new DefaultMessage(this.timeSource.getTimeMillis(), new ContextualNotification(this.configuration.getContext().with("cacheName", alias), EhcacheNotification.CACHE_ADDED.name())));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        this.messageConsumer.accept((Message)new DefaultMessage(this.timeSource.getTimeMillis(), new ContextualNotification(this.configuration.getContext().with("cacheName", alias), EhcacheNotification.CACHE_REMOVED.name())));
    }

    public void stateTransition(Status from, Status to) {
        switch (to) {
            case AVAILABLE: {
                this.managementRegistry.register(this);
                this.messageConsumer.accept((Message)new DefaultMessage(this.timeSource.getTimeMillis(), new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_AVAILABLE.name())));
                break;
            }
            case MAINTENANCE: {
                this.messageConsumer.accept((Message)new DefaultMessage(this.timeSource.getTimeMillis(), new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_MAINTENANCE.name())));
                break;
            }
            case UNINITIALIZED: {
                this.messageConsumer.accept((Message)new DefaultMessage(this.timeSource.getTimeMillis(), new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_CLOSED.name())));
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                break;
            }
            default: {
                throw new AssertionError(to);
            }
        }
    }

    public synchronized void startStatisticCollector() {
        if (this.task == null) {
            StatisticsProviderConfiguration providerConfiguration = this.configuration.getConfigurationFor(EhcacheStatisticsProvider.class);
            long timeToDisableMs = TimeUnit.MILLISECONDS.convert(providerConfiguration.timeToDisable(), providerConfiguration.timeToDisableUnit());
            long pollingIntervalMs = Math.round((double)timeToDisableMs * 0.75);
            final AtomicLong lastPoll = new AtomicLong(System.currentTimeMillis());
            this.task = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DefaultCollectorService.this.cacheManager.getStatus() == Status.AVAILABLE) {
                            ArrayList<Context> cacheContexts = new ArrayList<Context>();
                            for (ContextContainer cacheContext : DefaultCollectorService.this.managementRegistry.getContextContainer().getSubContexts()) {
                                cacheContexts.add(DefaultCollectorService.this.configuration.getContext().with(cacheContext.getName(), cacheContext.getValue()));
                            }
                            long now = DefaultCollectorService.this.timeSource.getTimeMillis();
                            ArrayList<ContextualStatistics> statistics = new ArrayList<ContextualStatistics>();
                            for (Map.Entry entry : DefaultCollectorService.this.selectedStatsPerCapability.entrySet()) {
                                for (ContextualStatistics contextualStatistics : ((StatisticQuery)((StatisticQuery.Builder)((StatisticQuery.Builder)entry.getValue()).since(lastPoll.get()).on(cacheContexts)).build()).execute()) {
                                    statistics.add(contextualStatistics);
                                }
                            }
                            lastPoll.set(System.currentTimeMillis());
                            if (!statistics.isEmpty()) {
                                DefaultCollectorService.this.messageConsumer.accept((Message)new DefaultMessage(now, statistics.toArray(new ContextualStatistics[statistics.size()])));
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }, pollingIntervalMs, pollingIntervalMs, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopStatisticCollector() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }

    public void updateCollectedStatistics(String capabilityName, Collection<String> statisticNames) {
        StatisticQuery.Builder builder = this.managementRegistry.withCapability(capabilityName).queryStatistics(statisticNames);
        this.selectedStatsPerCapability.put(capabilityName, builder);
    }
}

