/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.Cache;
import org.ehcache.EhcacheManager;
import org.ehcache.Status;
import org.ehcache.events.CacheManagerListener;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.management.CapabilityManagement;
import org.ehcache.management.ManagementRegistry;
import org.ehcache.management.SharedManagementService;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.management.registry.DefaultCapabilityManagement;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.CacheManagerProviderService;
import org.ehcache.spi.service.ServiceDependencies;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.context.ContextContainer;

@ServiceDependencies(value={CacheManagerProviderService.class, ManagementRegistry.class})
public class DefaultSharedManagementService
implements SharedManagementService {
    private final ConcurrentMap<String, ManagementRegistry> delegates = new ConcurrentHashMap();

    public void start(ServiceProvider serviceProvider) {
        final ManagementRegistry managementRegistry = (ManagementRegistry)serviceProvider.getService(ManagementRegistry.class);
        final String alias = managementRegistry.getConfiguration().getCacheManagerAlias();
        final EhcacheManager ehcacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        ehcacheManager.registerListener(new CacheManagerListener(){

            public void cacheAdded(String alias2, Cache<?, ?> cache) {
            }

            public void cacheRemoved(String alias2, Cache<?, ?> cache) {
            }

            public void stateTransition(Status from, Status to) {
                if (from == Status.UNINITIALIZED && to == Status.AVAILABLE) {
                    if (DefaultSharedManagementService.this.delegates.put(alias, managementRegistry) != null) {
                        throw new IllegalStateException("Duplicate cache manager alias in ManagementRegistry : " + alias);
                    }
                } else if (from == Status.AVAILABLE && to == Status.UNINITIALIZED) {
                    DefaultSharedManagementService.this.delegates.remove(alias);
                    ehcacheManager.deregisterListener((CacheManagerListener)this);
                }
            }
        });
    }

    public void stop() {
    }

    @Override
    public Collection<ContextContainer> getContexts() {
        ArrayList<ContextContainer> contexts = new ArrayList<ContextContainer>();
        for (ManagementRegistry delegate : this.delegates.values()) {
            contexts.add(delegate.getContext());
        }
        return contexts;
    }

    @Override
    public Map<String, Collection<Capability>> getCapabilities() {
        LinkedHashMap<String, Collection<Capability>> capabilities = new LinkedHashMap<String, Collection<Capability>>();
        for (Map.Entry entry : this.delegates.entrySet()) {
            capabilities.put((String)entry.getKey(), ((ManagementRegistry)entry.getValue()).getCapabilities());
        }
        return capabilities;
    }

    @Override
    public Collection<ManagementProvider<?>> getManagementProvidersByCapability(String capabilityName) {
        ArrayList allProviders = new ArrayList();
        for (ManagementRegistry managementRegistry : this.delegates.values()) {
            allProviders.addAll(managementRegistry.getManagementProvidersByCapability(capabilityName));
        }
        return allProviders;
    }

    @Override
    public CapabilityManagement withCapability(String capabilityName) {
        return new DefaultCapabilityManagement(this, capabilityName);
    }
}

