/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.management.annotations.Named;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.management.registry.CacheBinding;
import org.terracotta.management.call.Parameter;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.capabilities.context.CapabilityContext;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.context.Context;
import org.terracotta.management.stats.Statistic;

public abstract class CacheBindingManagementProviderSkeleton<V>
implements ManagementProvider<CacheBinding> {
    protected final ConcurrentMap<CacheBinding, V> managedObjects = new ConcurrentHashMap();
    private final String cacheManagerAlias;
    private final String name;

    protected CacheBindingManagementProviderSkeleton(String cacheManagerAlias) {
        this.cacheManagerAlias = cacheManagerAlias;
        Named named = this.getClass().getAnnotation(Named.class);
        this.name = named == null ? this.getClass().getSimpleName() : named.value();
    }

    @Override
    public final Class<CacheBinding> managedType() {
        return CacheBinding.class;
    }

    @Override
    public final void register(CacheBinding managedObject) {
        this.managedObjects.putIfAbsent(managedObject, this.createManagedObject(managedObject));
    }

    @Override
    public final void unregister(CacheBinding managedObject) {
        Object managed = this.managedObjects.remove(managedObject);
        if (managed != null) {
            this.close(managedObject, managed);
        }
    }

    @Override
    public final CapabilityContext getCapabilityContext() {
        return new CapabilityContext(Arrays.asList(new CapabilityContext.Attribute("cacheManagerName", true), new CapabilityContext.Attribute("cacheName", true)));
    }

    @Override
    public final String getCapabilityName() {
        return this.name;
    }

    @Override
    public final Capability getCapability() {
        String name = this.getCapabilityName();
        CapabilityContext context = this.getCapabilityContext();
        Collection<Descriptor> descriptors = this.getDescriptors();
        return this.createCapability(name, context, descriptors);
    }

    @Override
    public final boolean supports(Context context) {
        return this.findManagedObject(context) != null;
    }

    @Override
    public void close() {
        for (CacheBinding cacheBinding : this.managedObjects.keySet()) {
            this.unregister(cacheBinding);
        }
    }

    protected final Map.Entry<CacheBinding, V> findManagedObject(Context context) {
        String cacheManagerName = context.get("cacheManagerName");
        String cacheName = context.get("cacheName");
        if (!this.cacheManagerAlias.equals(cacheManagerName)) {
            return null;
        }
        for (Map.Entry entry : this.managedObjects.entrySet()) {
            if (!((CacheBinding)entry.getKey()).getAlias().equals(cacheName)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Map<String, Statistic<?, ?>> collectStatistics(Context context, Collection<String> statisticNames, long since) {
        throw new UnsupportedOperationException("Not a statistics provider : " + this.getCapabilityName());
    }

    @Override
    public <T> T callAction(Context context, String methodName, Class<T> returnType, Parameter ... parameters) {
        throw new UnsupportedOperationException("Not an action provider : " + this.getCapabilityName());
    }

    protected abstract Capability createCapability(String var1, CapabilityContext var2, Collection<Descriptor> var3);

    protected void close(CacheBinding cacheBinding, V managed) {
    }

    protected abstract V createManagedObject(CacheBinding var1);

    public String toString() {
        return "{cacheManagerAlias='" + this.cacheManagerAlias + '\'' + ", name='" + this.name + '\'' + ", managedObjects=" + this.managedObjects.keySet() + '}';
    }
}

