/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.spi.copy;

import java.util.Collection;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.impl.internal.classes.ClassInstanceConfiguration;
import org.ehcache.impl.internal.classes.ClassInstanceProvider;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCopyProvider
extends ClassInstanceProvider<Class<?>, Copier<?>>
implements CopyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCopyProvider.class);

    public DefaultCopyProvider(DefaultCopyProviderConfiguration configuration) {
        super(configuration, DefaultCopierConfiguration.class);
    }

    public <T> Copier<T> createKeyCopier(Class<T> clazz, Serializer<T> serializer, ServiceConfiguration<?> ... configs) {
        return this.createCopier(DefaultCopierConfiguration.Type.KEY, clazz, serializer, configs);
    }

    public <T> Copier<T> createValueCopier(Class<T> clazz, Serializer<T> serializer, ServiceConfiguration<?> ... configs) {
        return this.createCopier(DefaultCopierConfiguration.Type.VALUE, clazz, serializer, configs);
    }

    public void releaseCopier(Copier<?> copier) throws Exception {
        if (!(copier instanceof SerializingCopier)) {
            this.releaseInstance(copier);
        }
    }

    private <T> Copier<T> createCopier(DefaultCopierConfiguration.Type type, Class<T> clazz, Serializer<T> serializer, ServiceConfiguration<?> ... configs) {
        Copier<T> copier;
        DefaultCopierConfiguration<T> conf = DefaultCopyProvider.find(type, configs);
        ClassInstanceConfiguration preConfigured = (ClassInstanceConfiguration)this.preconfigured.get(clazz);
        if (conf != null && conf.getClazz().isAssignableFrom(SerializingCopier.class)) {
            if (serializer == null) {
                throw new IllegalStateException("No Serializer configured for type '" + clazz.getName() + "' which doesn't implement java.io.Serializable");
            }
            copier = new SerializingCopier<T>(serializer);
        } else if (conf == null && preConfigured != null && preConfigured.getClazz().isAssignableFrom(SerializingCopier.class)) {
            if (serializer == null) {
                throw new IllegalStateException("No Serializer configured for type '" + clazz.getName() + "' which doesn't implement java.io.Serializable");
            }
            copier = new SerializingCopier<T>(serializer);
        } else {
            copier = this.createCopier(clazz, conf, type);
        }
        LOG.debug("Copier for <{}> : {}", (Object)clazz.getName(), copier);
        return copier;
    }

    private <T> Copier<T> createCopier(Class<T> clazz, DefaultCopierConfiguration<T> config, DefaultCopierConfiguration.Type type) {
        Copier copier = (Copier)this.newInstance(clazz, config);
        if (copier == null) {
            Copier defaultInstance;
            copier = defaultInstance = (Copier)this.newInstance(clazz, new DefaultCopierConfiguration(IdentityCopier.class, type));
        }
        return copier;
    }

    private static <T> DefaultCopierConfiguration<T> find(DefaultCopierConfiguration.Type type, ServiceConfiguration<?> ... serviceConfigurations) {
        DefaultCopierConfiguration result = null;
        Collection copierConfigurations = ServiceUtils.findAmongst(DefaultCopierConfiguration.class, (Object[])serviceConfigurations);
        for (DefaultCopierConfiguration copierConfiguration : copierConfigurations) {
            if (copierConfiguration.getType() != type) continue;
            if (result != null) {
                throw new IllegalArgumentException("Duplicate " + (Object)((Object)type) + " copier : " + copierConfiguration);
            }
            result = copierConfiguration;
        }
        return result;
    }
}

