/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.CachePersistenceException;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.persistence.FileBasedStateRepository;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalPersistenceService
implements LocalPersistenceService {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final int DEL = 127;
    private static final char ESCAPE = '%';
    private static final Set<Character> ILLEGALS = new HashSet<Character>();
    private final ConcurrentMap<String, PersistenceSpace> knownPersistenceSpaces = new ConcurrentHashMap<String, PersistenceSpace>();
    private final File rootDirectory;
    private final File lockFile;
    private FileLock lock;
    private RandomAccessFile rw;
    private static final Logger LOGGER;
    private boolean started;

    public boolean isStarted() {
        return this.started;
    }

    public DefaultLocalPersistenceService(DefaultPersistenceConfiguration persistenceConfiguration) {
        if (persistenceConfiguration == null) {
            throw new NullPointerException("DefaultPersistenceConfiguration cannot be null");
        }
        this.rootDirectory = persistenceConfiguration.getRootDirectory();
        this.lockFile = new File(this.rootDirectory, ".lock");
    }

    public synchronized void start(ServiceProvider<Service> serviceProvider) {
        this.internalStart();
    }

    public synchronized void startForMaintenance(ServiceProvider<MaintainableService> serviceProvider) {
        this.internalStart();
    }

    void internalStart() {
        if (!this.started) {
            DefaultLocalPersistenceService.createLocationIfRequiredAndVerify(this.rootDirectory);
            try {
                this.rw = new RandomAccessFile(this.lockFile, "rw");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                this.lock = this.rw.getChannel().lock();
            }
            catch (Exception e) {
                try {
                    this.rw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException("Couldn't lock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = true;
            LOGGER.debug("RootDirectory Locked");
        }
    }

    public synchronized void stop() {
        if (this.started) {
            try {
                this.lock.release();
                this.rw.close();
                if (!this.lockFile.delete()) {
                    LOGGER.debug("Lock file was not deleted {}.", (Object)this.lockFile.getPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't unlock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = false;
            LOGGER.debug("RootDirectory Unlocked");
        }
    }

    private static void createLocationIfRequiredAndVerify(File rootDirectory) {
        if (!rootDirectory.exists()) {
            if (!rootDirectory.mkdirs()) {
                throw new IllegalArgumentException("Directory couldn't be created: " + rootDirectory.getAbsolutePath());
            }
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Location is not a directory: " + rootDirectory.getAbsolutePath());
        }
        if (!rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Location isn't writable: " + rootDirectory.getAbsolutePath());
        }
    }

    public boolean handlesResourceType(ResourceType<?> resourceType) {
        return ResourceType.Core.DISK.equals(resourceType);
    }

    public PersistableResourceService.PersistenceSpaceIdentifier<LocalPersistenceService> getPersistenceSpaceIdentifier(String name, CacheConfiguration<?, ?> config) throws CachePersistenceException {
        PersistenceSpace newSpace;
        boolean persistent = ((SizedResourcePool)config.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.DISK)).isPersistent();
        do {
            PersistenceSpace persistenceSpace;
            if ((persistenceSpace = (PersistenceSpace)this.knownPersistenceSpaces.get(name)) == null) continue;
            return persistenceSpace.identifier;
        } while ((newSpace = this.createSpace(name, persistent)) == null);
        return newSpace.identifier;
    }

    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        String name = null;
        for (Map.Entry entry : this.knownPersistenceSpaces.entrySet()) {
            if (!((PersistenceSpace)entry.getValue()).identifier.equals(identifier)) continue;
            name = (String)entry.getKey();
        }
        if (name == null) {
            throw new CachePersistenceException("Unknown space " + identifier);
        }
        PersistenceSpace persistenceSpace = (PersistenceSpace)this.knownPersistenceSpaces.remove(name);
        if (persistenceSpace != null) {
            for (FileBasedStateRepository stateRepository : persistenceSpace.stateRepositories.values()) {
                try {
                    stateRepository.close();
                }
                catch (IOException e) {
                    LOGGER.warn("StateRepository close failed - destroying persistence space {} to prevent corruption", identifier, (Object)e);
                    DefaultLocalPersistenceService.destroy(name, (DefaultPersistenceSpaceIdentifier)identifier, true);
                }
            }
        }
    }

    private PersistenceSpace createSpace(String name, boolean persistent) throws CachePersistenceException {
        DefaultPersistenceSpaceIdentifier persistenceSpaceIdentifier = new DefaultPersistenceSpaceIdentifier(this.getDirectoryFor(name));
        PersistenceSpace persistenceSpace = new PersistenceSpace(persistenceSpaceIdentifier);
        if (this.knownPersistenceSpaces.putIfAbsent(name, persistenceSpace) == null) {
            try {
                if (!persistent) {
                    DefaultLocalPersistenceService.destroy(name, persistenceSpaceIdentifier, true);
                }
                DefaultLocalPersistenceService.create(persistenceSpaceIdentifier.getDirectory());
            }
            catch (IOException e) {
                this.knownPersistenceSpaces.remove(name, persistenceSpace);
                throw new CachePersistenceException("Unable to create persistence space for " + name, (Throwable)e);
            }
            return persistenceSpace;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(String name) throws CachePersistenceException {
        boolean wasStarted = false;
        if (!this.started) {
            this.internalStart();
            wasStarted = true;
        }
        try {
            PersistenceSpace space = (PersistenceSpace)this.knownPersistenceSpaces.remove(name);
            if (space == null) {
                DefaultLocalPersistenceService.destroy(name, new DefaultPersistenceSpaceIdentifier(this.getDirectoryFor(name)), true);
            } else {
                DefaultLocalPersistenceService.destroy(name, space.identifier, true);
            }
        }
        finally {
            if (wasStarted) {
                this.stop();
            }
        }
    }

    public synchronized void destroyAll() {
        if (!this.started) {
            throw new IllegalStateException("Service must be started");
        }
        if (DefaultLocalPersistenceService.recursiveDeleteDirectoryContent(this.rootDirectory)) {
            LOGGER.debug("Destroyed all file based persistence contexts");
        } else {
            LOGGER.warn("Could not delete all file based persistence contexts");
        }
    }

    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        PersistenceSpace persistenceSpace = this.getPersistenceSpace(identifier);
        if (persistenceSpace != null) {
            this.validateName(name);
            File directory = new File(((DefaultPersistenceSpaceIdentifier)identifier).getDirectory(), name);
            if (!directory.mkdirs() && !directory.exists()) {
                throw new CachePersistenceException("Unable to create directory " + directory);
            }
            FileBasedStateRepository stateRepository = new FileBasedStateRepository(directory);
            FileBasedStateRepository previous = persistenceSpace.stateRepositories.putIfAbsent(name, stateRepository);
            if (previous != null) {
                return previous;
            }
            return stateRepository;
        }
        throw new CachePersistenceException("Unknown space " + identifier);
    }

    private PersistenceSpace getPersistenceSpace(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) {
        for (PersistenceSpace persistenceSpace : this.knownPersistenceSpaces.values()) {
            if (!persistenceSpace.identifier.equals(identifier)) continue;
            return persistenceSpace;
        }
        return null;
    }

    public FileBasedPersistenceContext createPersistenceContextWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        if (this.containsSpace(identifier)) {
            this.validateName(name);
            File directory = new File(((DefaultPersistenceSpaceIdentifier)identifier).getDirectory(), name);
            try {
                DefaultLocalPersistenceService.create(directory);
            }
            catch (IOException ex) {
                throw new CachePersistenceException("Unable to create persistence context for " + name + " in " + identifier);
            }
            return new DefaultFileBasedPersistenceContext(directory);
        }
        throw new CachePersistenceException("Unknown space: " + identifier);
    }

    private void validateName(String name) {
        if (!name.matches("[a-zA-Z0-9\\-_]+")) {
            throw new IllegalArgumentException("Name is invalid for persistence context: " + name);
        }
    }

    private boolean containsSpace(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) {
        for (PersistenceSpace persistenceSpace : this.knownPersistenceSpaces.values()) {
            if (!persistenceSpace.identifier.equals(identifier)) continue;
            return true;
        }
        return false;
    }

    File getLockFile() {
        return this.lockFile;
    }

    private File getDirectoryFor(String identifier) {
        File directory = new File(this.rootDirectory, DefaultLocalPersistenceService.safeIdentifier(identifier));
        for (File parent = directory.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!this.rootDirectory.equals(parent)) continue;
            return directory;
        }
        throw new IllegalArgumentException("Attempted to access file outside the persistence path");
    }

    private static void create(File directory) throws IOException, CachePersistenceException {
        if (directory.isDirectory()) {
            LOGGER.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else if (directory.mkdir()) {
            LOGGER.debug("Created {}", (Object)directory.getAbsolutePath());
        } else {
            throw new CachePersistenceException("Unable to create or reuse directory: " + directory.getAbsolutePath());
        }
    }

    private static void destroy(String identifier, DefaultPersistenceSpaceIdentifier fileBasedPersistenceContext, boolean verbose) {
        if (verbose) {
            LOGGER.debug("Destroying file based persistence context for {}", (Object)identifier);
        }
        if (fileBasedPersistenceContext.getDirectory().exists() && !DefaultLocalPersistenceService.tryRecursiveDelete(fileBasedPersistenceContext.getDirectory()) && verbose) {
            LOGGER.warn("Could not delete directory for context {}", (Object)identifier);
        }
    }

    private static boolean recursiveDeleteDirectoryContent(File file) {
        File[] contents = file.listFiles();
        if (contents == null) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " is not a directory");
        }
        boolean deleteSuccessful = true;
        for (File f : contents) {
            deleteSuccessful &= DefaultLocalPersistenceService.tryRecursiveDelete(f);
        }
        return deleteSuccessful;
    }

    private static boolean recursiveDelete(File file) {
        ArrayDeque<File> toDelete = new ArrayDeque<File>();
        toDelete.push(file);
        while (!toDelete.isEmpty()) {
            File target = (File)toDelete.pop();
            File[] contents = target.listFiles();
            if (contents == null || contents.length == 0) {
                if (!target.exists() || target.delete()) continue;
                return false;
            }
            toDelete.push(target);
            for (File f : contents) {
                toDelete.push(f);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_GC"})
    private static boolean tryRecursiveDelete(File file) {
        boolean interrupted = false;
        try {
            for (int i = 0; i < 5; ++i) {
                if (DefaultLocalPersistenceService.recursiveDelete(file) || !DefaultLocalPersistenceService.isWindows()) {
                    boolean bl = true;
                    return bl;
                }
                System.gc();
                System.runFinalization();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private static String safeIdentifier(String name) {
        return DefaultLocalPersistenceService.safeIdentifier(name, true);
    }

    static String safeIdentifier(String name, boolean withSha1) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || ILLEGALS.contains(Character.valueOf(c)) || c == '%') {
                sb.append('%');
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(c);
        }
        if (withSha1) {
            sb.append("_").append(DefaultLocalPersistenceService.sha1(name));
        }
        return sb.toString();
    }

    private static String sha1(String input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : DefaultLocalPersistenceService.getSha1Digest().digest(input.getBytes(UTF8))) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    private static MessageDigest getSha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"All JDKs must have SHA-1");
        }
    }

    static {
        ILLEGALS.add(Character.valueOf('/'));
        ILLEGALS.add(Character.valueOf('\\'));
        ILLEGALS.add(Character.valueOf('<'));
        ILLEGALS.add(Character.valueOf('>'));
        ILLEGALS.add(Character.valueOf(':'));
        ILLEGALS.add(Character.valueOf('\"'));
        ILLEGALS.add(Character.valueOf('|'));
        ILLEGALS.add(Character.valueOf('?'));
        ILLEGALS.add(Character.valueOf('*'));
        ILLEGALS.add(Character.valueOf('.'));
        LOGGER = LoggerFactory.getLogger(DefaultLocalPersistenceService.class);
    }

    private static class DefaultFileBasedPersistenceContext
    extends FileHolder
    implements FileBasedPersistenceContext {
        DefaultFileBasedPersistenceContext(File directory) {
            super(directory);
        }
    }

    private static class DefaultPersistenceSpaceIdentifier
    extends FileHolder
    implements PersistableResourceService.PersistenceSpaceIdentifier<LocalPersistenceService> {
        DefaultPersistenceSpaceIdentifier(File directory) {
            super(directory);
        }

        public Class<LocalPersistenceService> getServiceType() {
            return LocalPersistenceService.class;
        }
    }

    private static abstract class FileHolder {
        final File directory;

        FileHolder(File directory) {
            this.directory = directory;
        }

        public File getDirectory() {
            return this.directory;
        }
    }

    private static class PersistenceSpace {
        final DefaultPersistenceSpaceIdentifier identifier;
        final ConcurrentMap<String, FileBasedStateRepository> stateRepositories = new ConcurrentHashMap<String, FileBasedStateRepository>();

        private PersistenceSpace(DefaultPersistenceSpaceIdentifier identifier) {
            this.identifier = identifier;
        }
    }
}

