/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.terracotta.offheapstore.MetadataTuple;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapCache;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.util.Factory;

public class EhcacheConcurrentOffHeapClockCache<K, V>
extends AbstractConcurrentOffHeapCache<K, V>
implements EhcacheOffHeapBackingMap<K, V> {
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final AtomicLong[] counters;

    protected EhcacheConcurrentOffHeapClockCache(EvictionAdvisor<? super K, ? super V> evictionAdvisor, Factory<? extends PinnableSegment<K, V>> segmentFactory, int ssize) {
        super(segmentFactory, ssize);
        this.evictionAdvisor = evictionAdvisor;
        this.counters = new AtomicLong[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            this.counters[i] = new AtomicLong();
        }
    }

    @Override
    public long allocatedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getAllocatedMemory();
        }
        return total;
    }

    @Override
    public long occupiedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getOccupiedMemory();
        }
        return total;
    }

    @Override
    public long dataAllocatedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataAllocatedMemory();
        }
        return total;
    }

    @Override
    public long dataOccupiedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataOccupiedMemory();
        }
        return total;
    }

    @Override
    public long dataSize() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataSize();
        }
        return total;
    }

    @Override
    public long longSize() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getSize();
        }
        return total;
    }

    @Override
    public long tableCapacity() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getTableCapacity();
        }
        return total;
    }

    @Override
    public long usedSlotCount() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getUsedSlotCount();
        }
        return total;
    }

    @Override
    public long removedSlotCount() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getRemovedSlotCount();
        }
        return total;
    }

    @Override
    public long reprobeLength() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += (long)segment.getReprobeLength();
        }
        return total;
    }

    @Override
    public long vitalMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getVitalMemory();
        }
        return total;
    }

    @Override
    public long dataVitalMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataVitalMemory();
        }
        return total;
    }

    @Override
    public V compute(K key, final BiFunction<K, V, V> mappingFunction, final boolean pin) {
        MetadataTuple result = this.computeWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current == null ? null : current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return MetadataTuple.metadataTuple((Object)newValue, (int)((pin ? 0x40000000 : 0) | current.metadata()));
                }
                return MetadataTuple.metadataTuple((Object)newValue, (int)((pin ? 0x40000000 : 0) | (EhcacheConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0)));
            }
        });
        return (V)(result == null ? null : result.value());
    }

    @Override
    public V computeIfPresent(K key, final BiFunction<K, V, V> mappingFunction) {
        MetadataTuple result = this.computeIfPresentWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return current;
                }
                return MetadataTuple.metadataTuple((Object)newValue, (int)(EhcacheConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0));
            }
        });
        return (V)(result == null ? null : result.value());
    }

    @Override
    public V computeIfPresentAndPin(K key, final BiFunction<K, V, V> mappingFunction) {
        MetadataTuple result = this.computeIfPresentWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return MetadataTuple.metadataTuple((Object)newValue, (int)(0x40000000 | current.metadata()));
                }
                return MetadataTuple.metadataTuple((Object)newValue, (int)(0x40000000 | (EhcacheConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0)));
            }
        });
        return (V)(result == null ? null : result.value());
    }

    @Override
    public boolean computeIfPinned(K key, final BiFunction<K, V, V> remappingFunction, final Function<V, Boolean> unpinFunction) {
        final AtomicBoolean unpin = new AtomicBoolean();
        this.computeIfPresentWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                if ((current.metadata() & 0x40000000) != 0) {
                    Object oldValue = current.value();
                    Object newValue = remappingFunction.apply(k, oldValue);
                    Boolean unpinLocal = (Boolean)unpinFunction.apply(oldValue);
                    if (newValue == null) {
                        unpin.set(true);
                        return null;
                    }
                    if (oldValue == newValue) {
                        unpin.set(unpinLocal);
                        return MetadataTuple.metadataTuple((Object)oldValue, (int)(current.metadata() & (unpinLocal != false ? -1073741825 : -1)));
                    }
                    unpin.set(false);
                    return MetadataTuple.metadataTuple((Object)newValue, (int)(EhcacheConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0));
                }
                return current;
            }
        });
        return unpin.get();
    }

    @Override
    public long nextIdFor(K key) {
        return this.counters[this.getIndexFor(key.hashCode())].getAndIncrement();
    }
}

