/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap.factories;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.ehcache.config.EvictionAdvisor;
import org.terracotta.offheapstore.ReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.util.Factory;

public class EhcacheSegmentFactory<K, V>
implements Factory<PinnableSegment<K, V>> {
    private final Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final EhcacheSegment.EvictionListener<K, V> evictionListener;

    public EhcacheSegmentFactory(PageSource source, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory, int initialTableSize, EvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcacheSegment.EvictionListener<K, V> evictionListener) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.evictionAdvisor = evictionAdvisor;
        this.evictionListener = evictionListener;
    }

    public PinnableSegment<K, V> newInstance() {
        StorageEngine storageEngine = (StorageEngine)this.storageEngineFactory.newInstance();
        try {
            return new EhcacheSegment<K, V>(this.tableSource, storageEngine, this.tableSize, this.evictionAdvisor, this.evictionListener);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcacheSegment<K, V>
    extends ReadWriteLockedOffHeapClockCache<K, V> {
        public static final int ADVISED_AGAINST_EVICTION = 0x20000000;
        private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
        private final EvictionListener<K, V> evictionListener;

        EhcacheSegment(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize, EvictionAdvisor<? super K, ? super V> evictionAdvisor, EvictionListener<K, V> evictionListener) {
            super(source, true, storageEngine, tableSize);
            this.evictionAdvisor = evictionAdvisor;
            this.evictionListener = evictionListener;
        }

        public V put(K key, V value) {
            int metadata = this.getEvictionAdviceStatus(key, value);
            return (V)this.put(key, value, metadata);
        }

        private int getEvictionAdviceStatus(K key, V value) {
            return this.evictionAdvisor.adviseAgainstEviction(key, value) ? 0x20000000 : 0;
        }

        public V putPinned(K key, V value) {
            int metadata = this.getEvictionAdviceStatus(key, value) | 0x40000000;
            return (V)this.put(key, value, metadata);
        }

        protected boolean evictable(int status) {
            return super.evictable(status) && (status & 0x20000000) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evict(int index, boolean shrink) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Map.Entry entry = this.getEntryAtTableOffset(index);
                boolean evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.onEviction(entry.getKey(), entry.getValue());
                }
                boolean bl = evicted;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        public static interface EvictionListener<K, V> {
            public void onEviction(K var1, V var2);
        }
    }
}

