/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.config.copy;

import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class DefaultCopyProviderConfiguration
extends ClassInstanceProviderConfiguration<Class<?>, Copier<?>>
implements ServiceCreationConfiguration<CopyProvider> {
    public DefaultCopyProviderConfiguration() {
    }

    public DefaultCopyProviderConfiguration(DefaultCopyProviderConfiguration other) {
        this.getDefaults().putAll(other.getDefaults());
    }

    public Class<CopyProvider> getServiceType() {
        return CopyProvider.class;
    }

    public <T> DefaultCopyProviderConfiguration addCopierFor(Class<T> clazz, Class<? extends Copier<T>> copierClass) {
        return this.addCopierFor(clazz, copierClass, false);
    }

    public <T> DefaultCopyProviderConfiguration addCopierFor(Class<T> clazz, Class<? extends Copier<T>> copierClass, boolean overwrite) {
        if (clazz == null) {
            throw new NullPointerException("Copy target class cannot be null");
        }
        if (copierClass == null) {
            throw new NullPointerException("Copier class cannot be null");
        }
        if (!overwrite && this.getDefaults().containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate copier for class : " + clazz);
        }
        this.getDefaults().put(clazz, new DefaultCopierConfiguration(copierClass));
        return this;
    }
}

