/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.ServiceLocator;
import org.ehcache.core.spi.cache.Store;
import org.ehcache.core.spi.cache.events.StoreEventSource;
import org.ehcache.core.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.core.spi.cache.tiering.CachingTier;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.impl.internal.store.tiering.CacheStoreServiceConfiguration;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.SupplementaryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.statistics.StatisticsManager;

public class CacheStore<K, V>
implements Store<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheStore.class);
    private final AtomicReference<CachingTier<K, V>> cachingTierRef;
    private final CachingTier<K, V> noopCachingTier;
    private final CachingTier<K, V> realCachingTier;
    private final AuthoritativeTier<K, V> authoritativeTier;
    private final CacheStoreStatsSettings cacheStoreStatsSettings;

    public CacheStore(CachingTier<K, V> cachingTier, AuthoritativeTier<K, V> authoritativeTier) {
        this.cachingTierRef = new AtomicReference<CachingTier<K, CachingTier<K, V>>>(cachingTier);
        this.authoritativeTier = authoritativeTier;
        this.realCachingTier = cachingTier;
        this.noopCachingTier = new NoopCachingTier<K, V>(authoritativeTier);
        this.realCachingTier.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                CacheStore.this.authoritativeTier.flush(key, valueHolder);
            }
        });
        StatisticsManager.associate(cachingTier).withParent((Object)this);
        StatisticsManager.associate(authoritativeTier).withParent((Object)this);
        this.cacheStoreStatsSettings = new CacheStoreStatsSettings(cachingTier, authoritativeTier);
        StatisticsManager.associate((Object)this.cacheStoreStatsSettings).withParent((Object)this);
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K key) {
                    try {
                        return CacheStore.this.authoritativeTier.getAndFault(key);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    public boolean containsKey(K key) throws CacheAccessException {
        return this.authoritativeTier.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.PutStatus put(K key, V value) throws CacheAccessException {
        try {
            Store.PutStatus putStatus = this.authoritativeTier.put(key, value);
            return putStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws CacheAccessException {
        Store.ValueHolder previous = null;
        try {
            previous = this.authoritativeTier.putIfAbsent(key, value);
        }
        finally {
            if (previous == null) {
                this.cachingTier().invalidate(key);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) throws CacheAccessException {
        try {
            boolean bl = this.authoritativeTier.remove(key);
            return bl;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.RemoveStatus remove(K key, V value) throws CacheAccessException {
        Store.RemoveStatus removed = null;
        try {
            Store.RemoveStatus removeStatus = removed = this.authoritativeTier.remove(key, value);
            return removeStatus;
        }
        finally {
            if (removed != null && removed.equals((Object)Store.RemoveStatus.REMOVED)) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> replace(K key, V value) throws CacheAccessException {
        Store.ValueHolder previous = null;
        boolean exceptionThrown = true;
        try {
            previous = this.authoritativeTier.replace(key, value);
            exceptionThrown = false;
        }
        finally {
            if (exceptionThrown || previous != null) {
                this.cachingTier().invalidate(key);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws CacheAccessException {
        Store.ReplaceStatus replaced = null;
        try {
            replaced = this.authoritativeTier.replace(key, oldValue, newValue);
        }
        finally {
            if (replaced != null && replaced.equals((Object)Store.ReplaceStatus.HIT)) {
                this.cachingTier().invalidate(key);
            }
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws CacheAccessException {
        CachingTier<K, V> cachingTier;
        boolean interrupted = false;
        while (!this.cachingTierRef.compareAndSet(this.realCachingTier, this.noopCachingTier)) {
            cachingTier = this.noopCachingTier;
            synchronized (cachingTier) {
                if (this.cachingTierRef.get() == this.noopCachingTier) {
                    try {
                        this.noopCachingTier.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            this.authoritativeTier.clear();
        }
        finally {
            try {
                this.realCachingTier.clear();
            }
            finally {
                if (!this.cachingTierRef.compareAndSet(this.noopCachingTier, this.realCachingTier)) {
                    throw new AssertionError((Object)"Something bad happened");
                }
                cachingTier = this.noopCachingTier;
                synchronized (cachingTier) {
                    this.noopCachingTier.notify();
                }
            }
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.authoritativeTier.getStoreEventSource();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return this.authoritativeTier.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction, replaceEqual);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K k) {
                    try {
                        return CacheStore.this.authoritativeTier.computeIfAbsentAndFault(k, mappingFunction);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.computeIfPresent(key, remappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.computeIfPresent(key, remappingFunction, replaceEqual);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction, replaceEqual);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        try {
            Map map = this.authoritativeTier.bulkComputeIfAbsent(keys, mappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.addAll(this.realCachingTier.getConfigurationChangeListeners());
        configurationChangeListenerList.addAll(this.authoritativeTier.getConfigurationChangeListeners());
        return configurationChangeListenerList;
    }

    private CachingTier<K, V> cachingTier() {
        return this.cachingTierRef.get();
    }

    private static class NoopCachingTier<K, V>
    implements CachingTier<K, V> {
        private final AuthoritativeTier<K, V> authoritativeTier;

        public NoopCachingTier(AuthoritativeTier<K, V> authoritativeTier) {
            this.authoritativeTier = authoritativeTier;
        }

        public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
            Store.ValueHolder apply = (Store.ValueHolder)source.apply(key);
            this.authoritativeTier.flush(key, apply);
            return apply;
        }

        public void invalidate(K key) throws CacheAccessException {
        }

        public void clear() throws CacheAccessException {
        }

        public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        }

        public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
            return null;
        }
    }

    private static final class CacheStoreStatsSettings {
        @ContextAttribute(value="tags")
        private final Set<String> tags = new HashSet<String>(Arrays.asList("store"));
        @ContextAttribute(value="cachingTier")
        private final CachingTier<?, ?> cachingTier;
        @ContextAttribute(value="authoritativeTier")
        private final AuthoritativeTier<?, ?> authoritativeTier;

        CacheStoreStatsSettings(CachingTier<?, ?> cachingTier, AuthoritativeTier<?, ?> authoritativeTier) {
            this.cachingTier = cachingTier;
            this.authoritativeTier = authoritativeTier;
        }
    }

    @SupplementaryService
    public static class Provider
    implements Store.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<Store<?, ?>, Map.Entry<CachingTier.Provider, AuthoritativeTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            CacheStoreServiceConfiguration cacheStoreServiceConfig = (CacheStoreServiceConfiguration)ServiceLocator.findSingletonAmongst(CacheStoreServiceConfiguration.class, (Object[])serviceConfigs);
            if (cacheStoreServiceConfig == null) {
                throw new IllegalArgumentException("Cache store cannot be configured without explicit config");
            }
            Class<? extends CachingTier.Provider> cachingTierProviderClass = cacheStoreServiceConfig.cachingTierProvider();
            if (cachingTierProviderClass == null) {
                throw new IllegalArgumentException("Caching tier provider must be specified");
            }
            CachingTier.Provider cachingTierProvider = (CachingTier.Provider)this.serviceProvider.getService(cachingTierProviderClass);
            if (cachingTierProvider == null) {
                throw new IllegalArgumentException("No registered service for caching tier provider " + cachingTierProviderClass.getName());
            }
            Class<? extends AuthoritativeTier.Provider> authoritativeTierProviderClass = cacheStoreServiceConfig.authoritativeTierProvider();
            if (authoritativeTierProviderClass == null) {
                throw new IllegalArgumentException("Authoritative tier provider must be specified");
            }
            AuthoritativeTier.Provider authoritativeTierProvider = (AuthoritativeTier.Provider)this.serviceProvider.getService(authoritativeTierProviderClass);
            if (authoritativeTierProvider == null) {
                throw new IllegalArgumentException("No registered service for authoritative tier provider " + authoritativeTierProviderClass.getName());
            }
            CachingTier cachingTier = cachingTierProvider.createCachingTier(storeConfig, serviceConfigs);
            AuthoritativeTier authoritativeTier = authoritativeTierProvider.createAuthoritativeTier(storeConfig, serviceConfigs);
            CacheStore store = new CacheStore(cachingTier, authoritativeTier);
            this.registerStore(store, cachingTierProvider, authoritativeTierProvider);
            return store;
        }

        <K, V> void registerStore(CacheStore<K, V> store, CachingTier.Provider cachingTierProvider, AuthoritativeTier.Provider authoritativeTierProvider) {
            if (this.providersMap.putIfAbsent(store, new AbstractMap.SimpleEntry<CachingTier.Provider, AuthoritativeTier.Provider>(cachingTierProvider, authoritativeTierProvider)) != null) {
                throw new IllegalStateException("Instance of the Store already registered!");
            }
        }

        public void releaseStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            CacheStore cacheStore = (CacheStore)resource;
            ((CachingTier.Provider)entry.getKey()).releaseCachingTier(cacheStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).releaseAuthoritativeTier(cacheStore.authoritativeTier);
        }

        public void initStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            CacheStore cacheStore = (CacheStore)resource;
            ((CachingTier.Provider)entry.getKey()).initCachingTier(cacheStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).initAuthoritativeTier(cacheStore.authoritativeTier);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(CacheAccessException cause) {
            super(cause);
        }

        public CacheAccessException getCacheAccessException() {
            return (CacheAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

