/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap.holders;

import org.ehcache.core.spi.cache.Store;
import org.ehcache.expiry.Duration;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.ehcache.spi.copy.Copier;

public class CopiedOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final V copiedValue;
    @IgnoreSizeOf
    private final Copier<V> valueCopier;

    protected CopiedOnHeapValueHolder(long id, V value, long creationTime, long expirationTime, boolean veto, Copier<V> valueCopier) {
        super(id, creationTime, expirationTime, veto);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (valueCopier == null) {
            throw new NullPointerException("null copier");
        }
        this.valueCopier = valueCopier;
        this.copiedValue = valueCopier.copyForWrite(value);
    }

    public CopiedOnHeapValueHolder(Store.ValueHolder<V> valueHolder, V value, boolean veto, Copier<V> valueCopier, long now, Duration expiration) {
        super(valueHolder.getId(), valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT), veto);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (valueCopier == null) {
            throw new NullPointerException("null copier");
        }
        this.valueCopier = valueCopier;
        this.copiedValue = value;
        this.setHits(valueHolder.hits());
        this.accessed(now, expiration);
    }

    public CopiedOnHeapValueHolder(V value, long creationTime, boolean veto, Copier<V> valueCopier) {
        this(value, creationTime, -1L, veto, valueCopier);
    }

    public CopiedOnHeapValueHolder(V value, long creationTime, long expirationTime, boolean veto, Copier<V> valueCopier) {
        this(-1L, value, creationTime, expirationTime, veto, valueCopier);
    }

    public V value() {
        return (V)this.valueCopier.copyForRead(this.copiedValue);
    }
}

