/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.Builder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.ResourcePoolImpl;
import org.ehcache.core.config.ResourcePoolsImpl;

public class ResourcePoolsBuilder
implements Builder<ResourcePools> {
    private final Map<ResourceType, ResourcePool> resourcePools;

    private ResourcePoolsBuilder() {
        this(Collections.emptyMap());
    }

    private ResourcePoolsBuilder(Map<ResourceType, ResourcePool> resourcePools) {
        ResourcePoolsImpl.validateResourcePools(resourcePools.values());
        this.resourcePools = Collections.unmodifiableMap(resourcePools);
    }

    public static ResourcePoolsBuilder newResourcePoolsBuilder() {
        return new ResourcePoolsBuilder();
    }

    public static ResourcePoolsBuilder newResourcePoolsBuilder(ResourcePools pools) {
        ResourcePoolsBuilder poolsBuilder = new ResourcePoolsBuilder();
        for (ResourceType currentResourceType : pools.getResourceTypeSet()) {
            poolsBuilder = poolsBuilder.with(currentResourceType, pools.getPoolForResource(currentResourceType).getSize(), pools.getPoolForResource(currentResourceType).getUnit(), pools.getPoolForResource(currentResourceType).isPersistent());
        }
        return poolsBuilder;
    }

    public ResourcePoolsBuilder with(ResourceType type, long size, ResourceUnit unit, boolean persistent) {
        HashMap<ResourceType, ResourcePool> newPools = new HashMap<ResourceType, ResourcePool>(this.resourcePools);
        newPools.put(type, (ResourcePool)new ResourcePoolImpl(type, size, unit, persistent));
        return new ResourcePoolsBuilder(newPools);
    }

    public ResourcePoolsBuilder heap(long size, ResourceUnit unit) {
        return this.with((ResourceType)ResourceType.Core.HEAP, size, unit, false);
    }

    public ResourcePoolsBuilder offheap(long size, MemoryUnit unit) {
        return this.with((ResourceType)ResourceType.Core.OFFHEAP, size, (ResourceUnit)unit, false);
    }

    public ResourcePoolsBuilder disk(long size, MemoryUnit unit) {
        return this.disk(size, unit, false);
    }

    public ResourcePoolsBuilder disk(long size, MemoryUnit unit, boolean persistent) {
        return this.with((ResourceType)ResourceType.Core.DISK, size, (ResourceUnit)unit, persistent);
    }

    @Override
    public ResourcePools build() {
        return new ResourcePoolsImpl(this.resourcePools);
    }
}

