/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapCache;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.util.Factory;

public class EhcacheConcurrentOffHeapClockCache<K, V>
extends AbstractConcurrentOffHeapCache<K, V>
implements EhcacheOffHeapBackingMap<K, V> {
    private final AtomicLong[] counters;

    protected EhcacheConcurrentOffHeapClockCache(Factory<? extends PinnableSegment<K, V>> segmentFactory, int ssize) {
        super(segmentFactory, ssize);
        this.counters = new AtomicLong[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            this.counters[i] = new AtomicLong();
        }
    }

    @Override
    public V compute(K key, BiFunction<K, V, V> mappingFunction, boolean pin) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.compute(key, mappingFunction, pin);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<K, V, V> mappingFunction) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.computeIfPresent(key, mappingFunction);
    }

    @Override
    public boolean computeIfPinned(K key, BiFunction<K, V, V> remappingFunction, Function<V, Boolean> pinningFunction) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.computeIfPinned(key, remappingFunction, pinningFunction);
    }

    @Override
    public long nextIdFor(K key) {
        return this.counters[this.getIndexFor(key.hashCode())].getAndIncrement();
    }
}

