/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap.holders;

import java.nio.ByteBuffer;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.expiry.Duration;
import org.ehcache.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.serialization.Serializer;

public class SerializedOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final ByteBuffer buffer;
    private final Serializer<V> serializer;

    protected SerializedOnHeapValueHolder(long id, V value, long creationTime, long expirationTime, Serializer<V> serializer) {
        super(id, creationTime, expirationTime);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (serializer == null) {
            throw new NullPointerException("null serializer");
        }
        this.serializer = serializer;
        this.buffer = serializer.serialize(value).asReadOnlyBuffer();
    }

    public SerializedOnHeapValueHolder(V value, long creationTime, Serializer<V> serializer) {
        this(value, creationTime, -1L, serializer);
    }

    public SerializedOnHeapValueHolder(V value, long creationTime, long expirationTime, Serializer<V> serializer) {
        this(-1L, value, creationTime, expirationTime, serializer);
    }

    public SerializedOnHeapValueHolder(Store.ValueHolder<V> valueHolder, V value, Serializer<V> serializer, long now, Duration expiration) {
        this(valueHolder.getId(), value, valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT), serializer);
        this.setHits(valueHolder.hits());
        this.accessed(now, expiration);
    }

    public final V value() {
        try {
            return (V)this.serializer.read(this.buffer.duplicate());
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        SerializedOnHeapValueHolder that = (SerializedOnHeapValueHolder)((Object)other);
        if (!super.equals((Object)that)) {
            return false;
        }
        try {
            if (!this.serializer.equals(that.value(), this.buffer)) {
                return false;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + super.hashCode();
        return result;
    }
}

