/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap.holders;

import org.ehcache.expiry.Duration;
import org.ehcache.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.copy.Copier;

public class CopiedOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final V copiedValue;
    private final Copier<V> valueCopier;

    protected CopiedOnHeapValueHolder(long id, V value, long creationTime, long expirationTime, Copier<V> valueCopier) {
        super(id, creationTime, expirationTime);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (valueCopier == null) {
            throw new NullPointerException("null copier");
        }
        this.valueCopier = valueCopier;
        this.copiedValue = valueCopier.copyForWrite(value);
    }

    public CopiedOnHeapValueHolder(Store.ValueHolder<V> valueHolder, V value, Copier<V> valueCopier, long now, Duration expiration) {
        super(valueHolder.getId(), valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT));
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (valueCopier == null) {
            throw new NullPointerException("null copier");
        }
        this.valueCopier = valueCopier;
        this.copiedValue = value;
        this.setHits(valueHolder.hits());
        this.accessed(now, expiration);
    }

    public CopiedOnHeapValueHolder(V value, long creationTime, Copier<V> valueCopier) {
        this(value, creationTime, -1L, valueCopier);
    }

    public CopiedOnHeapValueHolder(V value, long creationTime, long expirationTime, Copier<V> valueCopier) {
        this(-1L, value, creationTime, expirationTime, valueCopier);
    }

    public V value() {
        return (V)this.valueCopier.copyForRead(this.copiedValue);
    }
}

