/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.copy;

import org.ehcache.exceptions.SerializerException;
import org.ehcache.internal.copy.ReadWriteCopier;
import org.ehcache.spi.serialization.Serializer;

public final class SerializingCopier<T>
extends ReadWriteCopier<T> {
    private final Serializer<T> serializer;

    public SerializingCopier(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public T copy(T obj) {
        try {
            return (T)this.serializer.read(this.serializer.serialize(obj));
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException("Copying failed.", (Throwable)e);
        }
    }

    public Serializer<T> getSerializer() {
        return this.serializer;
    }
}

