/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.loaderwriter.writebehind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.exceptions.BulkCacheWritingException;
import org.ehcache.loaderwriter.writebehind.AggregateWriteBehindQueue;
import org.ehcache.loaderwriter.writebehind.operations.CoalesceKeysFilter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;

public class WriteBehindDecoratorLoaderWriter<K, V>
implements CacheLoaderWriter<K, V> {
    private final CacheLoaderWriter<K, V> delegate;
    private final AggregateWriteBehindQueue<K, V> writeBehindQueue;

    public AggregateWriteBehindQueue<K, V> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    public WriteBehindDecoratorLoaderWriter(CacheLoaderWriter<K, V> loaderWriter, WriteBehindConfiguration config) {
        this.delegate = loaderWriter;
        this.writeBehindQueue = new AggregateWriteBehindQueue<K, V>(config, loaderWriter);
        this.writeBehindQueue.start();
        if (config.isWriteCoalescing()) {
            this.writeBehindQueue.setOperationsFilter(new CoalesceKeysFilter());
        }
    }

    public V load(K key) throws Exception {
        return this.writeBehindQueue.load(key);
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        HashMap<K, V> entries = new HashMap<K, V>();
        ArrayList<K> missingKeys = new ArrayList<K>();
        for (K k : keys) {
            V v = this.writeBehindQueue.load(k);
            if (v != null) {
                entries.put(k, v);
                continue;
            }
            missingKeys.add(k);
        }
        Map missingEntries = this.delegate.loadAll(missingKeys);
        entries.putAll(missingEntries);
        return entries;
    }

    public void write(K key, V value) throws Exception {
        this.writeBehindQueue.write(key, value);
    }

    public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) throws BulkCacheWritingException, Exception {
        for (Map.Entry<K, V> entry : entries) {
            this.writeBehindQueue.write(entry.getKey(), entry.getValue());
        }
    }

    public void delete(K key) throws Exception {
        this.writeBehindQueue.delete(key);
    }

    public void deleteAll(Iterable<? extends K> keys) throws BulkCacheWritingException, Exception {
        for (K k : keys) {
            this.writeBehindQueue.delete(k);
        }
    }
}

