/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap.portability;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ehcache.spi.serialization.Serializer;
import org.terracotta.offheapstore.storage.portability.Portability;

public class SerializerPortability<T>
implements Portability<T> {
    private final Serializer<T> serializer;

    public SerializerPortability(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    public ByteBuffer encode(T t) {
        try {
            return this.serializer.serialize(t);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public T decode(ByteBuffer byteBuffer) {
        try {
            return (T)this.serializer.read(byteBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o, ByteBuffer byteBuffer) {
        try {
            return this.serializer.equals(o, byteBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

