/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap.portability;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.spi.serialization.Serializer;
import org.terracotta.offheapstore.storage.portability.WriteBackPortability;
import org.terracotta.offheapstore.storage.portability.WriteContext;

public class OffHeapValueHolderPortability<V>
implements WriteBackPortability<OffHeapValueHolder<V>> {
    public static final int ACCESS_TIME_OFFSET = 8;
    public static final int EXPIRE_TIME_OFFSET = 16;
    private static final int FIELDS_OVERHEAD = 24;
    private final Serializer<V> serializer;

    public OffHeapValueHolderPortability(Serializer<V> serializer) {
        this.serializer = serializer;
    }

    public ByteBuffer encode(OffHeapValueHolder<V> valueHolder) {
        try {
            ByteBuffer serialized = this.serializer.serialize(valueHolder.value());
            ByteBuffer byteBuffer = ByteBuffer.allocate(serialized.remaining() + 24);
            byteBuffer.putLong(valueHolder.creationTime(TimeUnit.MILLISECONDS));
            byteBuffer.putLong(valueHolder.lastAccessTime(TimeUnit.MILLISECONDS));
            byteBuffer.putLong(valueHolder.expireTime(TimeUnit.MILLISECONDS));
            byteBuffer.put(serialized);
            byteBuffer.flip();
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException("Failure while encoding value holder " + valueHolder, e);
        }
    }

    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer) {
        return this.decode(byteBuffer, null);
    }

    public boolean equals(Object o, ByteBuffer byteBuffer) {
        return o.equals(this.decode(byteBuffer));
    }

    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer, WriteContext writeContext) {
        try {
            long creationTime = byteBuffer.getLong();
            long lastAccessTime = byteBuffer.getLong();
            long expireTime = byteBuffer.getLong();
            OffHeapValueHolder<Object> valueHolder = new OffHeapValueHolder<Object>(this.serializer.read(byteBuffer), creationTime, expireTime, lastAccessTime, writeContext);
            return valueHolder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

