/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.events.CacheEvents;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.SystemTimeSource;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceConfiguration;
import org.ehcache.internal.store.offheap.EhcacheConcurrentOffHeapClockCache;
import org.ehcache.internal.store.offheap.HeuristicConfiguration;
import org.ehcache.internal.store.offheap.OffHeapStoreUtils;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.statistics.StoreOperationOutcomes;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;
import org.terracotta.offheapstore.storage.OffHeapBufferStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.util.Factory;
import org.terracotta.statistics.StatisticsBuilder;
import org.terracotta.statistics.observer.OperationObserver;

public class OffHeapStore<K, V>
implements AuthoritativeTier<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TimeSource timeSource;
    private final Expiry<? super K, ? super V> expiry;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.UNINITIALIZED);
    private final Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private OperationObserver<StoreOperationOutcomes.GetOutcome> getOperationObserver = ((StatisticsBuilder.OperationStatisticBuilder)((StatisticsBuilder.OperationStatisticBuilder)((StatisticsBuilder.OperationStatisticBuilder)StatisticsBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of((Object)this)).named("get")).tag(new String[]{"local-offheap"})).build();
    private OperationObserver<StoreOperationOutcomes.PutOutcome> putOperationObserver = ((StatisticsBuilder.OperationStatisticBuilder)((StatisticsBuilder.OperationStatisticBuilder)((StatisticsBuilder.OperationStatisticBuilder)StatisticsBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of((Object)this)).named("put")).tag(new String[]{"local-offheap"})).build();
    private OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeOperationObserver = ((StatisticsBuilder.OperationStatisticBuilder)((StatisticsBuilder.OperationStatisticBuilder)((StatisticsBuilder.OperationStatisticBuilder)StatisticsBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of((Object)this)).named("remove")).tag(new String[]{"local-offheap"})).build();
    private volatile Callable<Void> valve;
    private volatile StoreEventListener<K, V> eventListener = CacheEvents.nullStoreEventListener();
    private BackingMapEvictionListener<K, V> mapEvictionListener;
    private volatile EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public OffHeapStore(Store.Configuration<K, V> config, Serializer<K> keySerializer, Serializer<V> valueSerializer, TimeSource timeSource, long sizeInBytes) {
        if (!this.status.compareAndSet(Status.UNINITIALIZED, Status.AVAILABLE)) {
            throw new AssertionError();
        }
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        EvictionVeto veto = config.getEvictionVeto();
        this.evictionVeto = veto != null ? OffHeapStore.wrap(veto) : Predicates.none();
        this.timeSource = timeSource;
        this.eventListener = CacheEvents.nullStoreEventListener();
        this.mapEvictionListener = new BackingMapEvictionListener();
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.sizeInBytes = sizeInBytes;
    }

    public Store.ValueHolder<V> get(K key) {
        this.checkKey(key);
        this.getOperationObserver.begin();
        Store.ValueHolder<V> result = this.internalGet(key, true);
        if (result == null) {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        }
        return result;
    }

    private Store.ValueHolder<V> internalGet(K key, final boolean updateAccess) {
        return this.map.compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    }
                    return null;
                }
                if (updateAccess) {
                    OffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                }
                return mappedValue;
            }
        }, false);
    }

    public boolean containsKey(K key) {
        this.checkKey(key);
        return this.internalGet(key, false) != null;
    }

    public void put(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.putOperationObserver.begin();
        while (true) {
            final long now = this.timeSource.getTimeMillis();
            try {
                this.map.compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                    public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                        if (mappedValue != null && mappedValue.isExpired(now)) {
                            mappedValue = null;
                        }
                        if (mappedValue == null) {
                            return OffHeapStore.this.newCreateValueHolder(key, value, now);
                        }
                        return OffHeapStore.this.newUpdatedValueHolder(key, value, mappedValue, now);
                    }
                }, false);
                return;
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, final V value) throws NullPointerException, CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference returnValue = new AtomicReference();
        while (true) {
            try {
                this.map.compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                    public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                        long now = OffHeapStore.this.timeSource.getTimeMillis();
                        if (mappedValue == null || mappedValue.isExpired(now)) {
                            if (mappedValue != null) {
                                OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                            }
                            return OffHeapStore.this.newCreateValueHolder(mappedKey, value, now);
                        }
                        returnValue.set(mappedValue);
                        OffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                        return mappedValue;
                    }
                }, false);
                return (Store.ValueHolder)returnValue.get();
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        this.checkKey(key);
        this.removeOperationObserver.begin();
        try {
            this.map.remove(key);
        }
        finally {
            this.removeOperationObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.SUCCESS);
        }
    }

    public boolean remove(K key, final V value) throws NullPointerException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.map.computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    return null;
                }
                if (mappedValue.value().equals(value)) {
                    removed.set(true);
                    return null;
                }
                OffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                return mappedValue;
            }
        });
        return removed.get();
    }

    public Store.ValueHolder<V> replace(K key, final V value) throws NullPointerException, CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    }
                    return null;
                }
                returnValue.set(mappedValue);
                return OffHeapStore.this.newUpdatedValueHolder(mappedKey, value, mappedValue, now);
            }
        };
        while (true) {
            try {
                this.map.compute(key, mappingFunction, false);
                return returnValue.get();
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    public boolean replace(K key, final V oldValue, final V newValue) throws NullPointerException, IllegalArgumentException, CacheAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicBoolean replaced = new AtomicBoolean(false);
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    }
                    return null;
                }
                if (oldValue.equals(mappedValue.value())) {
                    replaced.set(true);
                    return OffHeapStore.this.newUpdatedValueHolder(mappedKey, newValue, mappedValue, now);
                }
                OffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                return mappedValue;
            }
        };
        while (true) {
            try {
                this.map.compute(key, mappingFunction, false);
                return replaced.get();
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    public void clear() throws CacheAccessException {
        this.map.clear();
    }

    public void destroy() throws CacheAccessException {
        this.close();
    }

    public void create() throws CacheAccessException {
    }

    public void close() {
        EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> localMap = this.map;
        if (localMap != null) {
            this.map = null;
            localMap.destroy();
        }
    }

    public void init() {
        this.map = this.createBackingMap(this.sizeInBytes, this.keySerializer, this.valueSerializer, this.evictionVeto);
    }

    public void maintenance() {
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
        this.eventListener = listener;
        ((BackingMapEvictionListener)this.mapEvictionListener).setStoreEventListener(this.eventListener);
    }

    public void disableStoreEventNotifications() {
        this.eventListener = CacheEvents.nullStoreEventListener();
        ((BackingMapEvictionListener)this.mapEvictionListener).setStoreEventListener(this.eventListener);
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() throws CacheAccessException {
        return new OffHeapStoreIterator();
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                Object existingValue = null;
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    }
                    mappedValue = null;
                } else {
                    existingValue = mappedValue.value();
                }
                Object computedValue = mappingFunction.apply(mappedKey, existingValue);
                if (computedValue == null) {
                    return null;
                }
                if (OffHeapStore.this.safeEquals(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    if (mappedValue != null) {
                        OffHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                    }
                    return mappedValue;
                }
                OffHeapStore.this.checkValue(computedValue);
                if (mappedValue != null) {
                    return OffHeapStore.this.newUpdatedValueHolder(key, computedValue, mappedValue, now);
                }
                return OffHeapStore.this.newCreateValueHolder(key, computedValue, now);
            }
        };
        while (true) {
            try {
                return this.map.compute(key, computeFunction, false);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            break;
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, false);
    }

    private Store.ValueHolder<V> internalComputeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction, boolean fault) throws CacheAccessException {
        this.checkKey(key);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    Object computedValue;
                    if (mappedValue != null) {
                        OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    }
                    if ((computedValue = mappingFunction.apply(mappedKey)) == null) {
                        return null;
                    }
                    OffHeapStore.this.checkValue(computedValue);
                    return OffHeapStore.this.newCreateValueHolder(mappedKey, computedValue, now);
                }
                OffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                return mappedValue;
            }
        };
        while (true) {
            try {
                return this.map.compute(key, computeFunction, fault);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            break;
        }
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = OffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        OffHeapStore.this.eventListener.onExpiration(OffHeapStore.wrap(mappedKey, mappedValue));
                    }
                    return null;
                }
                Object computedValue = remappingFunction.apply(mappedKey, mappedValue.value());
                if (computedValue == null) {
                    return null;
                }
                if (OffHeapStore.this.safeEquals(mappedValue.value(), computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    OffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                    return mappedValue;
                }
                OffHeapStore.this.checkValue(computedValue);
                return OffHeapStore.this.newUpdatedValueHolder(mappedKey, computedValue, mappedValue, now);
            }
        };
        while (true) {
            try {
                return this.map.compute(key, computeFunction, false);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            break;
        }
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            BiFunction biFunction = new BiFunction<K, V, V>(){

                public V apply(final K k, final V v) {
                    Map.Entry entry = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return k;
                        }

                        @Override
                        public V getValue() {
                            return v;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    Iterator iterator = ((Iterable)remappingFunction.apply(Collections.singleton(entry))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        OffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.compute(key, biFunction, replaceEqual);
            result.put(key, computed);
        }
        return result;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Function function = new Function<K, V>(){

                public V apply(K k) {
                    Iterator iterator = ((Iterable)mappingFunction.apply(Collections.singleton(k))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        OffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.computeIfAbsent(key, function);
            result.put(key, computed);
        }
        return result;
    }

    public Store.ValueHolder<V> getAndFault(K key) throws CacheAccessException {
        this.getOperationObserver.begin();
        this.checkKey(key);
        OffHeapValueHolder mappedValue = (OffHeapValueHolder)this.map.getAndPin(key);
        if (mappedValue == null) {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        }
        return mappedValue;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, true);
    }

    public boolean flush(K key, Store.ValueHolder<V> valueHolder, CachingTier<K, V> cachingTier) {
        if (valueHolder instanceof OffHeapValueHolder) {
            throw new IllegalArgumentException("ValueHolder must come from the caching tier");
        }
        this.checkKey(key);
        return this.map.unpin(key);
    }

    public void registerEmergencyValve(Callable<Void> valve) {
        this.valve = valve;
    }

    private boolean safeEquals(V existingValue, V computedValue) {
        return existingValue == computedValue || existingValue != null && existingValue.equals(computedValue);
    }

    private void setAccessTimeAndExpiry(K key, OffHeapValueHolder<V> valueHolder, long now) {
        valueHolder.setLastAccessTimeMillis(now);
        Duration duration = this.expiry.getExpiryForAccess(key, valueHolder.value());
        if (duration != null) {
            if (duration.isForever()) {
                valueHolder.setExpireTimeMillis(-1L);
            } else {
                valueHolder.setExpireTimeMillis(OffHeapStore.safeExpireTime(now, duration));
            }
        }
        valueHolder.writeBack();
    }

    private OffHeapValueHolder<V> newUpdatedValueHolder(K key, V value, OffHeapValueHolder<V> existing, long now) {
        Duration duration = this.expiry.getExpiryForUpdate(key, existing.value(), value);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration == null) {
            return new OffHeapValueHolder<V>(value, now, existing.expireTime(TimeUnit.MILLISECONDS));
        }
        if (duration.isForever()) {
            return new OffHeapValueHolder<V>(value, now, -1L);
        }
        return new OffHeapValueHolder<V>(value, now, OffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newCreateValueHolder(K key, V value, long now) {
        Duration duration = this.expiry.getExpiryForCreation(key, value);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration.isForever()) {
            return new OffHeapValueHolder<V>(value, now, -1L);
        }
        return new OffHeapValueHolder<V>(value, now, OffHeapStore.safeExpireTime(now, duration));
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = TimeUnit.MILLISECONDS.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    public void handleOversizeMappingException(K key, OversizeMappingException cause) throws CacheAccessException {
        this.handleOversizeMappingException(key, cause, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOversizeMappingException(K key, OversizeMappingException cause, AtomicBoolean invokeValve) throws CacheAccessException {
        if (!this.map.shrinkOthers(key.hashCode()) && !this.invokeValve(invokeValve)) {
            for (Segment segment : this.map.getSegments()) {
                Lock lock = segment.writeLock();
                lock.lock();
                try {
                    for (Object keyToEvict : segment.keySet()) {
                        if (!this.map.updateMetadata(keyToEvict, 0x20000000, 0)) continue;
                        return;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            throw new CacheAccessException("The element with key '" + key + "' is too large to be stored" + " in this offheap store.", (Throwable)cause);
        }
    }

    private boolean invokeValve(AtomicBoolean invokeValve) throws CacheAccessException {
        if (invokeValve == null || !invokeValve.get()) {
            return false;
        }
        invokeValve.set(false);
        Callable<Void> valve = this.valve;
        if (valve != null) {
            try {
                valve.call();
            }
            catch (Exception exception) {
                throw new CacheAccessException("Failed invoking valve", (Throwable)exception);
            }
        }
        return true;
    }

    private EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto) {
        HeuristicConfiguration config = new HeuristicConfiguration(size);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreUtils.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        SerializerPortability<K> keyPortability = new SerializerPortability<K>(keySerializer);
        OffHeapValueHolderPortability<V> elementPortability = new OffHeapValueHolderPortability<V>(valueSerializer);
        Factory storageEngineFactory = OffHeapBufferStorageEngine.createFactory((PointerSize)PointerSize.INT, (PageSource)source, (int)config.getSegmentDataPageSize(), keyPortability, elementPortability, (boolean)false, (boolean)true);
        EhcacheSegmentFactory<K, OffHeapValueHolder<V>> segmentFactory = new EhcacheSegmentFactory<K, OffHeapValueHolder<V>>((PageSource)source, storageEngineFactory, config.getInitialSegmentTableSize(), evictionVeto, this.mapEvictionListener);
        return new EhcacheConcurrentOffHeapClockCache(segmentFactory, config.getConcurrency());
    }

    private static <K, V> Cache.Entry<K, V> wrap(final K key, final OffHeapValueHolder<V> mappedValue) {
        return new Cache.Entry<K, V>(){

            public K getKey() {
                return key;
            }

            public V getValue() {
                return mappedValue.value();
            }

            public long getCreationTime(TimeUnit unit) {
                return mappedValue.creationTime(unit);
            }

            public long getLastAccessTime(TimeUnit unit) {
                return mappedValue.lastAccessTime(unit);
            }

            public float getHitRate(TimeUnit unit) {
                return mappedValue.hitRate(unit);
            }
        };
    }

    private static <K, V> Predicate<Map.Entry<K, OffHeapValueHolder<V>>> wrap(EvictionVeto<? super K, ? super V> delegate) {
        return new OffHeapEvictionVetoWrapper(delegate);
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private static class BackingMapEvictionListener<K, V>
    implements EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, OffHeapValueHolder<V>> {
        private StoreEventListener<K, V> storeEventListener = CacheEvents.nullStoreEventListener();

        private BackingMapEvictionListener() {
        }

        private void setStoreEventListener(StoreEventListener<K, V> storeEventListener) {
            if (storeEventListener == null) {
                throw new NullPointerException("store event listener cannot be null");
            }
            this.storeEventListener = storeEventListener;
        }

        @Override
        public void onEviction(K key, OffHeapValueHolder<V> value) {
            this.storeEventListener.onEviction(OffHeapStore.wrap(key, value));
        }
    }

    class OffHeapStoreIterator
    implements Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> {
        private final Iterator<Map.Entry<K, OffHeapValueHolder<V>>> mapIterator;

        OffHeapStoreIterator() {
            this.mapIterator = OffHeapStore.this.map.entrySet().iterator();
        }

        public boolean hasNext() throws CacheAccessException {
            return this.mapIterator.hasNext();
        }

        public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
            final Map.Entry next = this.mapIterator.next();
            return new Cache.Entry<K, Store.ValueHolder<V>>(){

                public K getKey() {
                    return next.getKey();
                }

                public Store.ValueHolder<V> getValue() {
                    return (Store.ValueHolder)next.getValue();
                }

                public long getCreationTime(TimeUnit unit) {
                    return ((OffHeapValueHolder)next.getValue()).creationTime(unit);
                }

                public long getLastAccessTime(TimeUnit unit) {
                    return ((OffHeapValueHolder)next.getValue()).lastAccessTime(unit);
                }

                public float getHitRate(TimeUnit unit) {
                    return ((OffHeapValueHolder)next.getValue()).hitRate(unit);
                }
            };
        }
    }

    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider {
        private ServiceProvider serviceProvider;

        public <K, V> OffHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            TimeSourceConfiguration timeSourceConfig = (TimeSourceConfiguration)ServiceLocator.findSingletonAmongst(TimeSourceConfiguration.class, (Object[])serviceConfigs);
            TimeSource timeSource = timeSourceConfig != null ? timeSourceConfig.getTimeSource() : SystemTimeSource.INSTANCE;
            SerializationProvider serializationProvider = (SerializationProvider)this.serviceProvider.findService(SerializationProvider.class);
            Serializer keySerializer = serializationProvider.createSerializer(storeConfig.getKeyType(), storeConfig.getClassLoader(), new ServiceConfiguration[0]);
            Serializer valueSerializer = serializationProvider.createSerializer(storeConfig.getValueType(), storeConfig.getClassLoader(), new ServiceConfiguration[0]);
            ResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.OFFHEAP);
            if (!(offHeapPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapStore only supports resources with memory unit");
            }
            MemoryUnit unit = (MemoryUnit)offHeapPool.getUnit();
            return new OffHeapStore<K, V>(storeConfig, keySerializer, valueSerializer, timeSource, unit.toBytes(offHeapPool.getSize()));
        }

        public void releaseStore(Store<?, ?> resource) {
            resource.close();
        }

        public void start(ServiceConfiguration<?> config, ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }
    }

    private static class OffHeapEvictionVetoWrapper<K, V>
    implements Predicate<Map.Entry<K, OffHeapValueHolder<V>>> {
        private final EvictionVeto<K, V> delegate;

        private OffHeapEvictionVetoWrapper(EvictionVeto<? super K, ? super V> delegate) {
            this.delegate = delegate;
        }

        public boolean test(Map.Entry<K, OffHeapValueHolder<V>> argument) {
            return this.delegate.test((Object)OffHeapStore.wrap(argument.getKey(), argument.getValue()));
        }
    }
}

