/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap;

import java.util.concurrent.TimeUnit;
import org.ehcache.internal.store.heap.OnHeapValueHolder;

class TimeStampedOnHeapValueHolder<V>
implements OnHeapValueHolder<V> {
    static final long NO_EXPIRE = -1L;
    private final OnHeapValueHolder<V> delegate;
    private volatile long expireTime;

    TimeStampedOnHeapValueHolder(OnHeapValueHolder<V> delegate, long expireTime) {
        if (delegate == null) {
            throw new NullPointerException("null delegate");
        }
        this.delegate = delegate;
        this.setExpireTimeMillis(expireTime);
        this.expireTime = expireTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeStampedOnHeapValueHolder)) {
            return false;
        }
        return this.delegate.equals(((TimeStampedOnHeapValueHolder)o).delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public V value() {
        return (V)this.delegate.value();
    }

    public long creationTime(TimeUnit unit) {
        return this.delegate.creationTime(unit);
    }

    public float hitRate(TimeUnit unit) {
        return this.delegate.hitRate(unit);
    }

    public long lastAccessTime(TimeUnit unit) {
        return this.delegate.lastAccessTime(unit);
    }

    @Override
    public void setAccessTimeMillis(long accessTime) {
        this.delegate.setAccessTimeMillis(accessTime);
    }

    @Override
    public void setExpireTimeMillis(long expireTime) {
        if (expireTime <= 0L && expireTime != -1L) {
            throw new IllegalArgumentException("invalid expire time: " + expireTime);
        }
        this.expireTime = expireTime;
    }

    @Override
    public boolean isExpired(long now) {
        long expire = this.expireTime;
        if (expire == -1L) {
            return false;
        }
        return expire <= now;
    }

    @Override
    public long getExpireTimeMillis() {
        return this.expireTime;
    }
}

