/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.disk;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ehcache.function.BiFunction;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.store.disk.DiskStorageFactory;
import org.ehcache.internal.store.disk.DiskStore;
import org.ehcache.internal.store.disk.ElementSubstituteFilter;
import org.ehcache.internal.store.disk.HashEntry;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segment<K, V>
extends ReentrantReadWriteLock {
    private static final Logger LOG = LoggerFactory.getLogger((String)Segment.class.getName());
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = Integer.highestOneBit(Integer.MAX_VALUE);
    protected volatile int count;
    protected int modCount;
    private final DiskStorageFactory<K, V> disk;
    private volatile HashEntry<K, V>[] table;
    private int threshold;
    private final TimeSource timeSource;
    private final DiskStore<K, V> diskStore;

    public Segment(int initialCapacity, float loadFactor, DiskStorageFactory<K, V> primary, TimeSource timeSource, DiskStore<K, V> diskStore) {
        this.timeSource = timeSource;
        this.diskStore = diskStore;
        this.table = new HashEntry[initialCapacity];
        this.threshold = (int)((float)this.table.length * loadFactor);
        this.modCount = 0;
        this.disk = primary;
    }

    public Segment(DiskStorageFactory<K, V> primary, TimeSource timeSource, DiskStore<K, V> diskStore) {
        this(16, 0.75f, primary, timeSource, diskStore);
    }

    private HashEntry<K, V> getFirst(int hash) {
        HashEntry<K, V>[] tab = this.table;
        return tab[hash & tab.length - 1];
    }

    private DiskStorageFactory.Element<K, V> decode(HashEntry<K, V> hashEntry) {
        DiskStorageFactory.Element retrieve = hashEntry.element.getFactory().retrieve(hashEntry.element);
        retrieve.setFaulted(hashEntry.faulted.get());
        return retrieve;
    }

    private DiskStorageFactory.Element<K, V> decodeHit(DiskStorageFactory.DiskSubstitute<K, V> substitute) {
        return substitute.getFactory().retrieve(substitute, this);
    }

    private void free(DiskStorageFactory.DiskSubstitute<K, V> diskSubstitute) {
        this.free(diskSubstitute, false);
    }

    private void free(DiskStorageFactory.DiskSubstitute<K, V> diskSubstitute, boolean faultFailure) {
        diskSubstitute.getFactory().free(this.writeLock(), diskSubstitute, faultFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStorageFactory.Element<K, V> get(K key, int hash, boolean markFaulted) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        if (markFaulted) {
                            e.faulted.set(true);
                        }
                        DiskStorageFactory.Element element = this.decodeHit(e.element);
                        return element;
                    }
                    e = e.next;
                }
            }
            DiskStorageFactory.Element<K, V> element = null;
            return element;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStorageFactory.DiskSubstitute<K, V> unretrievedGet(K key, int hash) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        DiskStorageFactory.DiskSubstitute diskSubstitute = e.element;
                        return diskSubstitute;
                    }
                    e = e.next;
                }
            }
        }
        finally {
            this.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsKey(K key, int hash) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        boolean bl = true;
                        return bl;
                    }
                    e = e.next;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replace(K key, int hash, DiskStorageFactory.Element<K, V> oldElement, DiskStorageFactory.Element<K, V> newElement) {
        boolean installed = false;
        DiskStorageFactory.DiskSubstitute<K, V> encoded = this.disk.create(newElement);
        this.writeLock().lock();
        try {
            HashEntry<K, V> e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            boolean replaced = false;
            if (e != null && this.eq(this.decode(e), oldElement)) {
                replaced = true;
                DiskStorageFactory.DiskSubstitute onDiskSubstitute = e.element;
                e.element = encoded;
                e.faulted.set(false);
                installed = true;
                this.free(onDiskSubstitute);
            } else {
                this.free(encoded);
            }
            boolean bl = replaced;
            return bl;
        }
        finally {
            this.writeLock().unlock();
            if (installed) {
                encoded.installed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStorageFactory.Element<K, V> replace(K key, int hash, DiskStorageFactory.Element<K, V> newElement) {
        boolean installed = false;
        DiskStorageFactory.DiskSubstitute<K, V> encoded = this.disk.create(newElement);
        this.writeLock().lock();
        try {
            HashEntry<K, V> e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            DiskStorageFactory.Element<K, V> oldElement = null;
            if (e != null) {
                DiskStorageFactory.DiskSubstitute onDiskSubstitute = e.element;
                e.element = encoded;
                e.faulted.set(false);
                installed = true;
                oldElement = this.decode(e);
                this.free(onDiskSubstitute);
            } else {
                this.free(encoded);
            }
            DiskStorageFactory.Element<K, V> element = oldElement;
            return element;
        }
        finally {
            this.writeLock().unlock();
            if (installed) {
                encoded.installed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStorageFactory.Element<K, V> put(K key, int hash, DiskStorageFactory.Element<K, V> element, boolean onlyIfAbsent, boolean faulted) {
        boolean installed = false;
        DiskStorageFactory.DiskSubstitute<K, V> encoded = this.disk.create(element);
        this.writeLock().lock();
        try {
            DiskStorageFactory.Element<K, V> oldElement;
            HashEntry<K, V> first;
            if (this.count + 1 > this.threshold) {
                this.rehash();
            }
            HashEntry<K, V>[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry<K, V> e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e != null) {
                DiskStorageFactory.DiskSubstitute onDiskSubstitute = e.element;
                if (!onlyIfAbsent) {
                    e.element = encoded;
                    installed = true;
                    oldElement = this.decode(e);
                    this.free(onDiskSubstitute);
                    e.faulted.set(faulted);
                } else {
                    oldElement = this.decode(e);
                    this.free(encoded);
                }
            } else {
                oldElement = null;
                ++this.modCount;
                tab[index] = new HashEntry<K, V>(key, hash, first, encoded, new AtomicBoolean(faulted));
                installed = true;
                ++this.count;
            }
            DiskStorageFactory.Element<K, V> element2 = oldElement;
            return element2;
        }
        finally {
            this.writeLock().unlock();
            if (installed) {
                encoded.installed();
            }
        }
    }

    boolean putRawIfAbsent(K key, int hash, DiskStorageFactory.DiskMarker<K, V> encoded) throws IllegalArgumentException {
        this.writeLock().lock();
        try {
            HashEntry<K, V> first;
            if (this.count + 1 > this.threshold) {
                this.rehash();
            }
            HashEntry<K, V>[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry<K, V> e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e == null) {
                ++this.modCount;
                tab[index] = new HashEntry<K, V>(key, hash, first, encoded, new AtomicBoolean(false));
                ++this.count;
                boolean bl = true;
                return bl;
            }
            throw new IllegalArgumentException("Duplicate key detected");
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void rehash() {
        HashEntry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= MAXIMUM_CAPACITY) {
            return;
        }
        HashEntry[] newTable = new HashEntry[oldCapacity << 1];
        this.threshold = (int)((float)newTable.length * 0.75f);
        int sizeMask = newTable.length - 1;
        for (int i = 0; i < oldCapacity; ++i) {
            int k;
            HashEntry<K, V> e = oldTable[i];
            if (e == null) continue;
            HashEntry next = e.next;
            int idx = e.hash & sizeMask;
            if (next == null) {
                newTable[idx] = e;
                continue;
            }
            HashEntry<K, V> lastRun = e;
            int lastIdx = idx;
            HashEntry last = next;
            while (last != null) {
                k = last.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            HashEntry<K, V> p = e;
            while (p != lastRun) {
                k = p.hash & sizeMask;
                HashEntry n = newTable[k];
                newTable[k] = new HashEntry(p.key, p.hash, n, p.element, p.faulted);
                p = p.next;
            }
        }
        this.table = newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStorageFactory.Element<K, V> remove(K key, int hash, DiskStorageFactory.Element<K, V> value) {
        this.writeLock().lock();
        try {
            HashEntry<K, V> first;
            HashEntry<K, V>[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry<K, V> e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            DiskStorageFactory.Element<K, V> oldValue = null;
            if (e != null) {
                oldValue = this.decode(e);
                if (value == null || this.eq(value, oldValue)) {
                    ++this.modCount;
                    HashEntry newFirst = e.next;
                    HashEntry<K, V> p = first;
                    while (p != e) {
                        newFirst = new HashEntry(p.key, p.hash, newFirst, p.element, p.faulted);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    DiskStorageFactory.DiskSubstitute onDiskSubstitute = e.element;
                    this.free(onDiskSubstitute);
                    --this.count;
                } else {
                    oldValue = null;
                }
            }
            if (oldValue == null) {
                LOG.debug("remove deleted nothing");
            }
            DiskStorageFactory.Element<K, V> element = oldValue;
            return element;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.writeLock().lock();
        try {
            if (this.count != 0) {
                HashEntry<K, V>[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    HashEntry<K, V> e = tab[i];
                    while (e != null) {
                        this.free(e.element);
                        e = e.next;
                    }
                    tab[i] = null;
                }
                ++this.modCount;
                this.count = 0;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fault(K key, int hash, DiskStorageFactory.Placeholder<K, V> expect, DiskStorageFactory.DiskMarker<K, V> fault, boolean skipFaulted) {
        this.writeLock().lock();
        try {
            boolean bl = this.faultInternal(key, hash, expect, fault, skipFaulted);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private boolean faultInternal(K key, int hash, DiskStorageFactory.Placeholder<K, V> expect, DiskStorageFactory.DiskMarker<K, V> fault, boolean skipFaulted) {
        boolean faulted = false;
        if (this.count != 0) {
            HashEntry<K, V> e = this.getFirst(hash);
            while (e != null) {
                if (e.hash == hash && key.equals(e.key)) {
                    faulted = e.faulted.get();
                }
                e = e.next;
            }
            if (skipFaulted && faulted) {
                this.free(fault, false);
                return true;
            }
            if (this.findAndFree(key, hash, expect, fault)) {
                return true;
            }
        }
        this.free(fault, true);
        return false;
    }

    private boolean findAndFree(K key, int hash, DiskStorageFactory.Placeholder<K, V> expect, DiskStorageFactory.DiskMarker<K, V> fault) {
        HashEntry<K, V> e = this.getFirst(hash);
        while (e != null) {
            if (e.hash == hash && key.equals(e.key) && expect == e.element) {
                e.element = fault;
                this.free(expect);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Deprecated
    private boolean returnSafeDeprecated(K key, int hash, DiskStorageFactory.Element<K, V> element) {
        this.notifyEviction(this.remove(key, hash, null));
        return false;
    }

    private void notifyEviction(DiskStorageFactory.Element<K, V> evicted) {
    }

    DiskStorageFactory.Element<K, V> evict(K key, int hash, DiskStorageFactory.DiskSubstitute<K, V> value) {
        return this.evict(key, hash, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStorageFactory.Element<K, V> evict(K key, int hash, DiskStorageFactory.DiskSubstitute<K, V> value, boolean notify) {
        if (this.writeLock().tryLock()) {
            DiskStorageFactory.Element<K, V> evictedElement = null;
            try {
                HashEntry<K, V> first;
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<K, V> e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null && !e.faulted.get()) {
                    evictedElement = this.decode(e);
                }
                if (!(e == null || value != null && value != e.element || e.faulted.get())) {
                    ++this.modCount;
                    HashEntry newFirst = e.next;
                    HashEntry<K, V> p = first;
                    while (p != e) {
                        newFirst = new HashEntry(p.key, p.hash, newFirst, p.element, p.faulted);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    DiskStorageFactory.DiskSubstitute onDiskSubstitute = e.element;
                    this.free(onDiskSubstitute);
                    --this.count;
                } else {
                    evictedElement = null;
                }
                DiskStorageFactory.Element<K, V> element = evictedElement;
                return element;
            }
            finally {
                this.writeLock().unlock();
                if (!notify || evictedElement == null || evictedElement.isExpired(this.timeSource.getTimeMillis())) {
                    // empty if block
                }
            }
        }
        return null;
    }

    void addRandomSample(ElementSubstituteFilter filter, int sampleSize, Collection<DiskStorageFactory.DiskSubstitute<K, V>> sampled, int seed) {
        int tableStart;
        if (this.count == 0) {
            return;
        }
        HashEntry<K, V>[] tab = this.table;
        int tableIndex = tableStart = seed & tab.length - 1;
        do {
            HashEntry<K, V> e = tab[tableIndex];
            while (e != null) {
                DiskStorageFactory.DiskSubstitute value = e.element;
                if (!e.faulted.get() && filter.allows(value)) {
                    sampled.add(value);
                }
                e = e.next;
            }
            if (sampled.size() < sampleSize) continue;
            return;
        } while ((tableIndex = tableIndex + 1 & tab.length - 1) != tableStart);
    }

    Iterator<HashEntry<K, V>> hashIterator() {
        return new HashIterator();
    }

    @Override
    public String toString() {
        return super.toString() + " count: " + this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanUpFailedMarker(K key, int hash) {
        DiskStorageFactory.DiskSubstitute substitute;
        boolean failedMarker;
        block8: {
            boolean readLocked = false;
            failedMarker = false;
            if (!this.isWriteLockedByCurrentThread()) {
                this.readLock().lock();
                readLocked = true;
            }
            substitute = null;
            try {
                if (this.count == 0) break block8;
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key) && (substitute = e.element) instanceof DiskStorageFactory.Placeholder) {
                        failedMarker = ((DiskStorageFactory.Placeholder)substitute).hasFailedToFlush();
                        break;
                    }
                    e = e.next;
                }
            }
            finally {
                if (readLocked) {
                    this.readLock().unlock();
                }
            }
        }
        if (failedMarker) {
            this.evict(key, hash, substitute, false);
        }
        return failedMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flush(K key, int hash, Store.ValueHolder<V> valueHolder, CachingTier<K, V> cachingTier) {
        DiskStorageFactory.DiskSubstitute diskSubstitute = null;
        this.readLock().lock();
        try {
            HashEntry<K, V> e = this.getFirst(hash);
            while (e != null) {
                if (e.hash == hash && key.equals(e.key)) {
                    Object retrievedValue;
                    Object value = valueHolder.value();
                    DiskStorageFactory.Element<K, V> retrieved = this.disk.retrieve(e.element);
                    Object object = retrieved == null ? null : (retrievedValue = retrieved.getValueHolder() == null ? null : retrieved.getValueHolder().value());
                    if (!Segment.eq(value, retrievedValue)) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean b = e.faulted.compareAndSet(true, false);
                    diskSubstitute = e.element;
                    if (diskSubstitute instanceof DiskStorageFactory.Placeholder) {
                        if (((DiskStorageFactory.Placeholder)diskSubstitute).hasFailedToFlush() && this.evict(key, hash, diskSubstitute) != null) {
                            diskSubstitute = null;
                        }
                    } else if (diskSubstitute instanceof DiskStorageFactory.DiskMarker) {
                        DiskStorageFactory.DiskMarker diskMarker = (DiskStorageFactory.DiskMarker)diskSubstitute;
                        diskMarker.updateStats(0.0f, cachingTier.getExpireTimeMillis(valueHolder));
                    }
                    boolean bl = b;
                    return bl;
                }
                e = e.next;
            }
        }
        finally {
            this.readLock().unlock();
            if (diskSubstitute != null && cachingTier.isExpired(valueHolder)) {
                this.evict(key, hash, diskSubstitute);
            }
        }
        return false;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFaultedBit() {
        this.writeLock().lock();
        try {
            HashEntry<K, V>[] arr$ = this.table;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                HashEntry<K, V> hashEntry;
                HashEntry<K, V> entry = hashEntry = arr$[i$];
                while (entry != null) {
                    entry.faulted.set(false);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFaulted(int hash, K key) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        boolean bl = e.faulted.get();
                        return bl;
                    }
                    e = e.next;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskStorageFactory.Element<K, V> compute(K key, int hash, BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>> mappingFunction, Compute compute, boolean preserveFault, boolean markFaulted) {
        boolean installed = false;
        DiskStorageFactory.DiskSubstitute<K, V> encoded = null;
        this.writeLock().lock();
        try {
            DiskStorageFactory.Element newElement;
            HashEntry<K, V> first;
            if (this.count + 1 > this.threshold) {
                this.rehash();
            }
            HashEntry<K, V>[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry<K, V> e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e != null) {
                if (compute == Compute.IF_ABSENT) {
                    if (markFaulted) {
                        e.faulted.set(true);
                    }
                    newElement = this.decode(e);
                } else {
                    DiskStorageFactory.DiskSubstitute onDiskSubstitute = e.element;
                    installed = true;
                    DiskStorageFactory.Element<K, V> oldElement = this.decode(e);
                    newElement = (DiskStorageFactory.Element)mappingFunction.apply(key, oldElement);
                    if (newElement == null) {
                        this.remove(key, hash, null);
                    } else {
                        encoded = this.disk.create(newElement);
                        e.element = encoded;
                        this.free(onDiskSubstitute);
                        e.faulted.set(preserveFault && newElement.isFaulted() || markFaulted);
                    }
                }
            } else if (compute == Compute.IF_PRESENT) {
                newElement = null;
            } else {
                newElement = (DiskStorageFactory.Element)mappingFunction.apply(key, null);
                if (newElement == null) {
                    this.remove(key, hash, null);
                } else {
                    encoded = this.disk.create(newElement);
                    ++this.modCount;
                    tab[index] = new HashEntry<K, V>(key, hash, first, encoded, new AtomicBoolean(markFaulted));
                    installed = true;
                    ++this.count;
                }
            }
            DiskStorageFactory.Element element = newElement;
            return element;
        }
        finally {
            this.writeLock().unlock();
            if (installed && encoded != null) {
                encoded.installed();
            }
        }
    }

    private boolean eq(DiskStorageFactory.Element<K, V> e1, DiskStorageFactory.Element<K, V> e2) {
        Object v2;
        Object v1 = e1.getValueHolder().value();
        if (v1 == (v2 = e2.getValueHolder().value())) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    final class HashIterator
    implements Iterator<HashEntry<K, V>> {
        private int nextTableIndex;
        private final HashEntry<K, V>[] ourTable;
        private HashEntry<K, V> nextEntry;
        private HashEntry<K, V> lastReturned;

        private HashIterator() {
            if (Segment.this.count != 0) {
                this.ourTable = Segment.this.table;
                for (int j = this.ourTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.ourTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            } else {
                this.ourTable = null;
                this.nextTableIndex = -1;
            }
            this.advance();
        }

        private void advance() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry != null) {
                    return;
                }
            }
            while (this.nextTableIndex >= 0) {
                this.nextEntry = this.ourTable[this.nextTableIndex--];
                if (this.nextEntry == null) continue;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public HashEntry<K, V> next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Segment.this.remove(this.lastReturned.key, this.lastReturned.hash, null);
            this.lastReturned = null;
        }
    }

    static enum Compute {
        ALWAYS,
        IF_ABSENT,
        IF_PRESENT;

    }
}

