/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.internal.store.BaseOnHeapKey;
import org.ehcache.spi.serialization.Serializer;

class SerializedOnHeapKey<K>
extends BaseOnHeapKey<K> {
    private final ByteBuffer keyAsStored;
    private final Serializer<K> serializer;

    SerializedOnHeapKey(K actualKeyObject, Serializer<K> serializer) {
        super(actualKeyObject.hashCode());
        try {
            this.keyAsStored = serializer.serialize(actualKeyObject);
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
        this.serializer = serializer;
    }

    @Override
    public K getActualKeyObject() {
        try {
            return (K)this.serializer.read(this.keyAsStored);
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException((Throwable)e);
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
    }
}

