/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.concurrent;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class JSR166Helper {
    private JSR166Helper() {
    }

    static final class Unsafe {
        private static final sun.misc.Unsafe SMU;
        private static final Unsafe U;

        private static sun.misc.Unsafe getSMU() {
            try {
                return sun.misc.Unsafe.getUnsafe();
            }
            catch (SecurityException tryReflectionInstead) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<sun.misc.Unsafe>(){

                        @Override
                        public sun.misc.Unsafe run() throws Exception {
                            Class<sun.misc.Unsafe> k = sun.misc.Unsafe.class;
                            for (Field f : k.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (sun.misc.Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                }
            }
        }

        private Unsafe() {
        }

        public static Unsafe getUnsafe() {
            return U;
        }

        public long objectFieldOffset(Field pending) {
            return SMU.objectFieldOffset(pending);
        }

        public int arrayBaseOffset(Class<?> aClass) {
            return SMU.arrayBaseOffset(aClass);
        }

        public int arrayIndexScale(Class<?> aClass) {
            return SMU.arrayIndexScale(aClass);
        }

        public boolean compareAndSwapInt(Object o, long pending, int c, int i) {
            return SMU.compareAndSwapInt(o, pending, c, i);
        }

        public boolean compareAndSwapLong(Object o, long l, long l1, long l2) {
            return SMU.compareAndSwapLong(o, l, l1, l2);
        }

        public boolean compareAndSwapObject(Object o, long l, Object o1, Object o2) {
            return SMU.compareAndSwapObject(o, l, o1, o2);
        }

        public void park(boolean b, long l) {
            SMU.park(b, l);
        }

        public void unpark(Object o) {
            SMU.unpark(o);
        }

        public void putInt(Object o, long l, int i) {
            SMU.putInt(o, l, i);
        }

        public void putOrderedInt(Object o, long qtop, int i) {
            SMU.putOrderedInt(o, qtop, i);
        }

        public void putObject(Object o, long l, Object o1) {
            SMU.putObject(o, l, o1);
        }

        public void putOrderedObject(Object o, long l, Object o1) {
            SMU.putOrderedObject(o, l, o1);
        }

        public Object getObject(Object o, long l) {
            return SMU.getObject(o, l);
        }

        public Object getObjectVolatile(Object o, long l) {
            return SMU.getObjectVolatile(o, l);
        }

        public void putObjectVolatile(Object o, long l, Object o1) {
            SMU.putObjectVolatile(o, l, o1);
        }

        public int getAndAddInt(Object o, long offset, int val) {
            int temp;
            while (!SMU.compareAndSwapInt(o, offset, temp = SMU.getIntVolatile(o, offset), temp + val)) {
            }
            return temp;
        }

        public long getAndAddLong(Object o, long offset, long val) {
            long temp;
            while (!SMU.compareAndSwapLong(o, offset, temp = SMU.getLongVolatile(o, offset), temp + val)) {
            }
            return temp;
        }

        public Object getAndSetObject(Object o, long offset, Object val) {
            Object temp;
            while (!SMU.compareAndSwapObject(o, offset, temp = SMU.getObjectVolatile(o, offset), val)) {
            }
            return temp;
        }

        static {
            try {
                SMU = Unsafe.getSMU();
                U = new Unsafe();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static class StreamSupport {
        StreamSupport() {
        }

        static IntStream intStream(Spliterator.OfInt soi, boolean b) {
            throw new UnsupportedOperationException();
        }

        static LongStream longStream(Spliterator.OfLong sol, boolean b) {
            throw new UnsupportedOperationException();
        }

        static DoubleStream doubleStream(Spliterator.OfDouble sod, boolean b) {
            throw new UnsupportedOperationException();
        }
    }

    static interface DoubleConsumer {
        public void accept(double var1);
    }

    static interface DoubleStream {
    }

    static interface LongConsumer {
        public void accept(long var1);
    }

    static interface LongStream {
    }

    static interface IntConsumer {
        public void accept(int var1);
    }

    static interface IntStream {
    }

    public static interface Spliterator<T> {
        public static final int DISTINCT = 1;
        public static final int NONNULL = 256;
        public static final int CONCURRENT = 4096;
        public static final int SIZED = 64;
        public static final int IMMUTABLE = 1024;
        public static final int SUBSIZED = 16384;

        public Spliterator<T> trySplit();

        public long estimateSize();

        public void forEachRemaining(Consumer<? super T> var1);

        public boolean tryAdvance(Consumer<? super T> var1);

        public int characteristics();

        public static interface OfDouble {
        }

        public static interface OfLong {
        }

        public static interface OfInt {
        }
    }

    public static interface IntBinaryOperator {
        public int applyAsInt(int var1, int var2);
    }

    public static interface DoubleBinaryOperator {
        public long applyAsDouble(double var1, double var3);
    }

    public static interface LongBinaryOperator {
        public long applyAsLong(long var1, long var3);
    }

    public static interface ToDoubleBiFunction<A, B> {
        public double applyAsDouble(A var1, B var2);
    }

    public static interface ToDoubleFunction<A> {
        public double applyAsDouble(A var1);
    }

    public static interface ToIntBiFunction<A, B> {
        public int applyAsInt(A var1, B var2);
    }

    public static interface ToIntFunction<A> {
        public int applyAsInt(A var1);
    }

    public static interface ToLongBiFunction<A, B> {
        public long applyAsLong(A var1, B var2);
    }

    public static interface ToLongFunction<A> {
        public long applyAsLong(A var1);
    }

    public static interface Consumer<A> {
        public void accept(A var1);
    }

    public static interface BiConsumer<A, B> {
        public void accept(A var1, B var2);
    }
}

