/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.classes;

import java.util.HashMap;
import java.util.Map;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.internal.classes.ClassInstanceProviderConfig;
import org.ehcache.internal.classes.ClassInstanceProviderFactoryConfig;
import org.ehcache.spi.service.ServiceConfiguration;

public class ClassInstanceProvider<T> {
    private final Map<String, Class<? extends T>> preconfiguredLoaders = new HashMap<String, Class<? extends T>>();
    private final Class<? extends ClassInstanceProviderFactoryConfig<T>> factoryConfig;
    private final Class<? extends ClassInstanceProviderConfig<T>> cacheLevelConfig;

    protected ClassInstanceProvider(Class<? extends ClassInstanceProviderFactoryConfig<T>> factoryConfig, Class<? extends ClassInstanceProviderConfig<T>> cacheLevelConfig) {
        this.factoryConfig = factoryConfig;
        this.cacheLevelConfig = cacheLevelConfig;
    }

    protected Class<? extends T> getPreconfigured(String alias) {
        return this.preconfiguredLoaders.get(alias);
    }

    protected T newInstance(String alias, CacheConfiguration<?, ?> cacheConfiguration) {
        Class<T> clazz = null;
        for (ServiceConfiguration serviceConfiguration : cacheConfiguration.getServiceConfigurations()) {
            if (!this.cacheLevelConfig.isAssignableFrom(serviceConfiguration.getClass())) continue;
            clazz = this.cacheLevelConfig.cast(serviceConfiguration).getClazz();
        }
        if (clazz == null) {
            clazz = this.getPreconfigured(alias);
        }
        try {
            return clazz != null ? (T)clazz.newInstance() : null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(ServiceConfiguration<?> config) {
        if (config != null && this.factoryConfig.isAssignableFrom(config.getClass())) {
            ClassInstanceProviderFactoryConfig<T> instanceProviderFactoryConfig = this.factoryConfig.cast(config);
            this.preconfiguredLoaders.putAll(instanceProviderFactoryConfig.getDefaults());
        }
    }

    public void stop() {
        this.preconfiguredLoaders.clear();
    }
}

