/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.cachingtier;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ehcache.Cache;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.exceptions.BulkCacheWriterException;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.statistics.CacheStatistics;

public class TieredCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> authority;
    final CachingTier<K> cachingTier;

    public TieredCache(Cache<K, V> authority, Class<K> keyClazz, Class<V> valueClazz, ServiceLocator serviceProvider, ServiceConfiguration<?> ... configs) {
        this.authority = authority;
        this.cachingTier = ((CachingTier.Provider)serviceProvider.findService(CachingTier.Provider.class)).createCachingTier(keyClazz, configs);
    }

    public boolean containsKey(K key) {
        return this.cachingTier.get(key) != null || this.authority.containsKey(key);
    }

    public V get(K key) {
        Fault<Object> f;
        Object cachedValue = this.cachingTier.get(key);
        if (cachedValue == null && (cachedValue = this.cachingTier.putIfAbsent(key, f = new Fault<Object>())) == null) {
            try {
                Object value = this.authority.get(key);
                if (value == null) {
                    this.cachingTier.remove(key, f);
                } else {
                    this.cachingTier.replace(key, f, value);
                }
                f.complete(value);
                return (V)value;
            }
            catch (Throwable throwable) {
                this.cachingTier.remove(key, f);
                f.fail(throwable);
                this.wrapAndThrow(throwable);
                throw new AssertionError();
            }
        }
        if (cachedValue instanceof Fault) {
            return ((Fault)cachedValue).get();
        }
        return (V)cachedValue;
    }

    private void wrapAndThrow(Throwable t) {
        if (t instanceof CacheAccessException) {
            throw new RuntimeException(t);
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        try {
            this.authority.put(key, value);
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        try {
            this.authority.remove(key);
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public boolean remove(K key, V value) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public V replace(K key, V value) throws NullPointerException {
        throw new UnsupportedOperationException("Implement me!");
    }

    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public CacheRuntimeConfiguration<K, V> getRuntimeConfiguration() {
        throw new UnsupportedOperationException("Implement me!");
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public void putAll(Map<? extends K, ? extends V> entries) throws BulkCacheWriterException {
        throw new UnsupportedOperationException("Implement me!");
    }

    public void removeAll(Set<? extends K> keys) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public void clear() {
        throw new UnsupportedOperationException("Implement me!");
    }

    public void close() {
        throw new UnsupportedOperationException("Implement me!");
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        throw new UnsupportedOperationException("Implement me!");
    }

    public CacheStatistics getStatistics() {
        throw new UnsupportedOperationException("implement me!");
    }

    public long getMaxCacheSize() {
        return this.cachingTier.getMaxCacheSize();
    }

    static class Fault<V> {
        private V value;
        private Throwable throwable;
        private boolean complete;

        Fault() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(V value) {
            Fault fault = this;
            synchronized (fault) {
                this.value = value;
                this.complete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get() {
            Fault fault = this;
            synchronized (fault) {
                boolean interrupted = false;
                try {
                    while (!this.complete) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.throwable != null) {
                    throw new RuntimeException("Faulting from underlying cache failed on other thread", this.throwable);
                }
                return this.value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail(Throwable t) {
            Fault fault = this;
            synchronized (fault) {
                this.throwable = t;
                this.complete = true;
                this.notifyAll();
            }
        }
    }
}

