/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config;

import org.ehcache.config.ResourcePool;
import org.ehcache.config.SizedResourcePool;

public interface ResourceType<T extends ResourcePool> {
    public Class<T> getResourcePoolClass();

    public boolean isPersistable();

    public boolean requiresSerialization();

    public static enum Core implements ResourceType<SizedResourcePool>
    {
        HEAP(false, false),
        OFFHEAP(false, true),
        DISK(true, true);

        private final boolean persistable;
        private final boolean requiresSerialization;

        private Core(boolean persistable, boolean requiresSerialization) {
            this.persistable = persistable;
            this.requiresSerialization = requiresSerialization;
        }

        @Override
        public Class<SizedResourcePool> getResourcePoolClass() {
            return SizedResourcePool.class;
        }

        @Override
        public boolean isPersistable() {
            return this.persistable;
        }

        @Override
        public boolean requiresSerialization() {
            return this.requiresSerialization;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

