/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.expiry;

import java.util.concurrent.TimeUnit;

public final class Duration {
    public static final Duration FOREVER = new Duration(0L, null, true);
    public static final Duration ZERO = new Duration(0L, TimeUnit.NANOSECONDS, false);
    private final TimeUnit timeUnit;
    private final long amount;

    public Duration(long amount, TimeUnit timeUnit) {
        this(amount, timeUnit, false);
    }

    private Duration(long amount, TimeUnit timeUnit, boolean forever) {
        if (!forever) {
            if (amount < 0L) {
                throw new IllegalArgumentException("amount must be greater than or equal to zero: " + amount);
            }
            if (timeUnit == null) {
                throw new NullPointerException("TimeUnit must not be null");
            }
        }
        this.amount = amount;
        this.timeUnit = timeUnit;
    }

    public long getAmount() {
        this.checkForever();
        return this.amount;
    }

    public TimeUnit getTimeUnit() {
        this.checkForever();
        return this.timeUnit;
    }

    private void checkForever() {
        if (this.isForever()) {
            throw new IllegalStateException("The calling code should be checking explicitly for Duration#FOREVER or isForever()");
        }
    }

    public boolean isForever() {
        return this.timeUnit == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.amount ^ this.amount >>> 32);
        result = this.amount != 0L ? 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode()) : 31 * result + (this.timeUnit == null ? 0 : 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Duration other = (Duration)obj;
        if (this.amount != other.amount) {
            return false;
        }
        if (this.timeUnit == null || other.timeUnit == null) {
            return this.timeUnit == other.timeUnit;
        }
        if (this.timeUnit != other.timeUnit) {
            return this.amount == 0L;
        }
        return true;
    }

    public String toString() {
        if (this.isForever()) {
            return "Duration[FOREVER]";
        }
        if (this.amount == 0L) {
            return "Duration[ZERO]";
        }
        return "Duration[amount=" + this.amount + ", timeUnit=" + this.timeUnit.name() + "]";
    }
}

