/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config;

import java.util.concurrent.TimeUnit;
import org.ehcache.Cache;
import org.ehcache.config.EvictionPrioritizer;
import org.ehcache.config.EvictionVeto;
import org.ehcache.function.Predicates;

public final class Eviction {
    public static <K, V> EvictionVeto<K, V> all() {
        return new EvictionVeto<K, V>(){

            @Override
            public boolean test(Cache.Entry<K, V> argument) {
                return Predicates.all().test(argument);
            }
        };
    }

    public static <K, V> EvictionVeto<K, V> none() {
        return new EvictionVeto<K, V>(){

            @Override
            public boolean test(Cache.Entry<K, V> argument) {
                return Predicates.none().test(argument);
            }
        };
    }

    public static enum Prioritizer implements EvictionPrioritizer<Object, Object>
    {
        LRU{

            @Override
            public int compare(Cache.Entry<Object, Object> a, Cache.Entry<Object, Object> b) {
                return Long.signum(b.getLastAccessTime(TimeUnit.NANOSECONDS) - a.getLastAccessTime(TimeUnit.NANOSECONDS));
            }
        }
        ,
        LFU{

            @Override
            public int compare(Cache.Entry<Object, Object> a, Cache.Entry<Object, Object> b) {
                return Float.compare(b.getHitRate(TimeUnit.NANOSECONDS), a.getHitRate(TimeUnit.NANOSECONDS));
            }
        }
        ,
        FIFO{

            @Override
            public int compare(Cache.Entry<Object, Object> a, Cache.Entry<Object, Object> b) {
                return Long.signum(b.getCreationTime(TimeUnit.NANOSECONDS) - a.getCreationTime(TimeUnit.NANOSECONDS));
            }
        };

    }
}

