/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.management.CacheStatisticsMXBean;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.statistics.BulkOps;
import org.ehcache.statistics.CacheStatistics;

class Eh107CacheStatisticsMXBean
extends Eh107MXBean
implements CacheStatisticsMXBean {
    private final CacheStatistics statistics;
    private final ConcurrentMap<BulkOps, AtomicLong> bulkMethodCounts;
    private final EnumMap<Stat, AtomicLong> baselines = new EnumMap(Stat.class);

    Eh107CacheStatisticsMXBean(String cacheName, Eh107CacheManager cacheManager, CacheStatistics statistics) {
        super(cacheName, cacheManager, "CacheStatistics");
        this.statistics = statistics;
        this.bulkMethodCounts = statistics.getBulkMethodEntries();
        for (Stat s : Stat.values()) {
            this.baselines.put(s, new AtomicLong());
        }
    }

    public void clear() {
        for (Map.Entry<Stat, AtomicLong> entry : this.baselines.entrySet()) {
            entry.getValue().set(entry.getKey().snapshot(this.statistics));
        }
    }

    public long getCacheHits() {
        return Eh107CacheStatisticsMXBean.minZero(this.statistics.getCacheHits() - this.baselineValue(Stat.GETS));
    }

    public float getCacheHitPercentage() {
        return Eh107CacheStatisticsMXBean.zeroForNaN(this.statistics.getCacheHitPercentage());
    }

    public long getCacheMisses() {
        return Eh107CacheStatisticsMXBean.minZero(this.statistics.getCacheMisses() - this.baselineValue(Stat.MISSES));
    }

    public float getCacheMissPercentage() {
        return Eh107CacheStatisticsMXBean.zeroForNaN(this.statistics.getCacheMissPercentage());
    }

    public long getCacheGets() {
        return Eh107CacheStatisticsMXBean.minZero(this.getBulkCount(BulkOps.GET_ALL) - this.baselineValue(Stat.BULK_GETS) + (this.statistics.getCacheGets() - this.baselineValue(Stat.GETS)));
    }

    public long getCachePuts() {
        return Eh107CacheStatisticsMXBean.minZero(this.getBulkCount(BulkOps.PUT_ALL) - this.baselineValue(Stat.BULK_PUTS) + (this.statistics.getCachePuts() - this.baselineValue(Stat.PUTS)));
    }

    public long getCacheRemovals() {
        return Eh107CacheStatisticsMXBean.minZero(this.getBulkCount(BulkOps.REMOVE_ALL) - this.baselineValue(Stat.BULK_REMOVES) + (this.statistics.getCacheRemovals() - this.baselineValue(Stat.REMOVALS)));
    }

    public long getCacheEvictions() {
        return Eh107CacheStatisticsMXBean.minZero(this.statistics.getCacheEvictions() - this.baselineValue(Stat.EVICTIONS));
    }

    public float getAverageGetTime() {
        return Eh107CacheStatisticsMXBean.zeroForNaN(this.statistics.getAverageGetTime());
    }

    public float getAveragePutTime() {
        return Eh107CacheStatisticsMXBean.zeroForNaN(this.statistics.getAveragePutTime());
    }

    public float getAverageRemoveTime() {
        return Eh107CacheStatisticsMXBean.zeroForNaN(this.statistics.getAverageRemoveTime());
    }

    private long getBulkCount(BulkOps op) {
        AtomicLong counter = (AtomicLong)this.bulkMethodCounts.get(op);
        return counter == null ? 0L : counter.get();
    }

    private long baselineValue(Stat stat) {
        return this.baselines.get((Object)stat).get();
    }

    private static long minZero(long value) {
        return Math.max(0L, value);
    }

    private static float zeroForNaN(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return value;
    }

    private static enum Stat {
        EVICTIONS{

            @Override
            long snapshot(CacheStatistics stats) {
                return stats.getCacheEvictions();
            }
        }
        ,
        GETS{

            @Override
            long snapshot(CacheStatistics stats) {
                return stats.getCacheGets();
            }
        }
        ,
        HITS{

            @Override
            long snapshot(CacheStatistics stats) {
                return stats.getCacheHits();
            }
        }
        ,
        MISSES{

            @Override
            long snapshot(CacheStatistics stats) {
                return stats.getCacheMisses();
            }
        }
        ,
        PUTS{

            @Override
            long snapshot(CacheStatistics stats) {
                return stats.getCachePuts();
            }
        }
        ,
        REMOVALS{

            @Override
            long snapshot(CacheStatistics stats) {
                return stats.getCacheRemovals();
            }
        }
        ,
        BULK_GETS{

            @Override
            long snapshot(CacheStatistics stats) {
                return ((AtomicLong)stats.getBulkMethodEntries().get(BulkOps.GET_ALL)).get();
            }
        }
        ,
        BULK_PUTS{

            @Override
            long snapshot(CacheStatistics stats) {
                return ((AtomicLong)stats.getBulkMethodEntries().get(BulkOps.PUT_ALL)).get();
            }
        }
        ,
        BULK_REMOVES{

            @Override
            long snapshot(CacheStatistics stats) {
                return ((AtomicLong)stats.getBulkMethodEntries().get(BulkOps.REMOVE_ALL)).get();
            }
        };


        abstract long snapshot(CacheStatistics var1);
    }
}

