/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.util.ChainBuilder;
import org.ehcache.clustered.server.offheap.ChainStorageEngine;
import org.ehcache.clustered.server.offheap.InternalChain;
import org.ehcache.clustered.server.offheap.OffHeapChainStorageEngine;
import org.terracotta.offheapstore.AbstractLockedOffHeapHashMap;
import org.terracotta.offheapstore.MapInternals;
import org.terracotta.offheapstore.eviction.EvictionListener;
import org.terracotta.offheapstore.eviction.EvictionListeningReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapChainMap<K>
implements MapInternals,
Iterable<Map.Entry<K, Chain>> {
    protected final HeadMap<K> heads;
    private final ChainStorageEngine<K> chainStorage;
    private volatile ChainMapEvictionListener<K> evictionListener;
    private static final Chain EMPTY_CHAIN = ChainBuilder.chainFromList(Collections.emptyList());

    private OffHeapChainMap(PageSource source, ChainStorageEngine<K> storageEngine) {
        this.chainStorage = storageEngine;
        EvictionListener listener = callable -> {
            try {
                Map.Entry entry = (Map.Entry)callable.call();
                try {
                    if (this.evictionListener != null) {
                        this.evictionListener.onEviction(entry.getKey(), (InternalChain)entry.getValue());
                    }
                }
                finally {
                    ((InternalChain)entry.getValue()).close();
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        };
        this.heads = new HeadMap<K>(listener, source, this.chainStorage);
    }

    public OffHeapChainMap(PageSource source, Factory<? extends ChainStorageEngine<K>> storageEngineFactory) {
        this(source, (ChainStorageEngine)storageEngineFactory.newInstance());
    }

    public OffHeapChainMap(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean shareByThieving) {
        this(source, new OffHeapChainStorageEngine<K>(source, keyPortability, minPageSize, maxPageSize, shareByThieving, shareByThieving));
    }

    OffHeapChainMap(HeadMap<K> heads, OffHeapChainStorageEngine<K> chainStorage) {
        this.chainStorage = chainStorage;
        this.heads = heads;
    }

    void setEvictionListener(ChainMapEvictionListener<K> listener) {
        this.evictionListener = listener;
    }

    public ChainStorageEngine<K> getStorageEngine() {
        return this.chainStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain get(K key) {
        Lock lock = this.heads.readLock();
        lock.lock();
        try {
            Chain chain;
            InternalChain chain2 = (InternalChain)this.heads.get(key);
            if (chain2 == null) {
                Chain chain3 = EMPTY_CHAIN;
                return chain3;
            }
            try {
                chain = chain2.detach();
            }
            catch (Throwable throwable) {
                chain2.close();
                throw throwable;
            }
            chain2.close();
            return chain;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Chain getAndAppend(K key, ByteBuffer element) {
        lock = this.heads.writeLock();
        lock.lock();
        while (true) lbl-1000:
        // 3 sources

        {
            if ((chain = (InternalChain)this.heads.get(key)) == null) {
                this.heads.put(key, this.chainStorage.newChain(element));
                var5_5 = OffHeapChainMap.EMPTY_CHAIN;
                return var5_5;
            }
            try {
                current = chain.detach();
                if (chain.append(element)) {
                    var6_6 = current;
                    return var6_6;
                }
                this.evict();
            }
            finally {
                chain.close();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void append(K key, ByteBuffer element) {
        lock = this.heads.writeLock();
        lock.lock();
        while (true) lbl-1000:
        // 3 sources

        {
            if ((chain = (InternalChain)this.heads.get(key)) == null) {
                this.heads.put(key, this.chainStorage.newChain(element));
                return;
            }
            try {
                if (chain.append(element)) {
                    return;
                }
                this.evict();
            }
            finally {
                chain.close();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void replaceAtHead(K key, Chain expected, Chain replacement) {
        lock = this.heads.writeLock();
        lock.lock();
        while (true) lbl-1000:
        // 3 sources

        {
            if ((chain = (InternalChain)this.heads.get(key)) == null) {
                if (expected.isEmpty()) {
                    throw new IllegalArgumentException("Empty expected sequence");
                }
                return;
            }
            try {
                if (chain.replace(expected, replacement)) {
                    return;
                }
                this.evict();
            }
            finally {
                chain.close();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, Chain chain) {
        block8: {
            Lock lock = this.heads.writeLock();
            lock.lock();
            try {
                InternalChain current = (InternalChain)this.heads.get(key);
                if (current != null) {
                    try {
                        this.replaceAtHead(key, current.detach(), chain);
                        break block8;
                    }
                    finally {
                        current.close();
                    }
                }
                if (!chain.isEmpty()) {
                    this.heads.put(key, this.chainStorage.newChain(chain));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    void remove(K key) {
        Lock lock = this.heads.writeLock();
        lock.lock();
        try {
            this.heads.removeNoReturn(key);
        }
        finally {
            lock.unlock();
        }
    }

    public void clear() {
        this.heads.writeLock().lock();
        try {
            this.heads.clear();
        }
        finally {
            this.heads.writeLock().unlock();
        }
    }

    public Set<K> keySet() {
        this.heads.writeLock().lock();
        try {
            Set set = this.heads.keySet();
            return set;
        }
        finally {
            this.heads.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, Chain>> iterator() {
        final Iterator<Map.Entry<K, InternalChain>> headsIterator = this.heads.detachedEntryIterator();
        return new Iterator<Map.Entry<K, Chain>>(){

            @Override
            public boolean hasNext() {
                return headsIterator.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map.Entry<K, Chain> next() {
                Lock lock = OffHeapChainMap.this.heads.readLock();
                lock.lock();
                try {
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
                    Map.Entry entry = (Map.Entry)headsIterator.next();
                    InternalChain chain = (InternalChain)entry.getValue();
                    if (chain == null) {
                        AbstractMap.SimpleImmutableEntry simpleImmutableEntry2 = new AbstractMap.SimpleImmutableEntry(entry.getKey(), EMPTY_CHAIN);
                        return simpleImmutableEntry2;
                    }
                    try {
                        simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(entry.getKey(), chain.detach());
                    }
                    catch (Throwable throwable) {
                        chain.close();
                        throw throwable;
                    }
                    chain.close();
                    return simpleImmutableEntry;
                }
                finally {
                    lock.unlock();
                }
            }
        };
    }

    private void evict() {
        int evictionIndex = this.heads.getEvictionIndex();
        if (evictionIndex < 0) {
            throw new OversizeMappingException("Storage Engine and Eviction Failed - Everything Pinned (" + this.getSize() + " mappings) \nStorage Engine : " + this.chainStorage);
        }
        this.heads.evict(evictionIndex, false);
    }

    public long getSize() {
        return this.heads.getSize();
    }

    public long getTableCapacity() {
        return this.heads.getTableCapacity();
    }

    public long getUsedSlotCount() {
        return this.heads.getUsedSlotCount();
    }

    public long getRemovedSlotCount() {
        return this.heads.getRemovedSlotCount();
    }

    public int getReprobeLength() {
        return this.heads.getReprobeLength();
    }

    public long getAllocatedMemory() {
        return this.heads.getAllocatedMemory();
    }

    public long getOccupiedMemory() {
        return this.heads.getOccupiedMemory();
    }

    public long getVitalMemory() {
        return this.heads.getVitalMemory();
    }

    public long getDataAllocatedMemory() {
        return this.heads.getDataAllocatedMemory();
    }

    public long getDataOccupiedMemory() {
        return this.heads.getDataOccupiedMemory();
    }

    public long getDataVitalMemory() {
        return this.heads.getDataVitalMemory();
    }

    public long getDataSize() {
        return this.heads.getDataSize();
    }

    public boolean shrink() {
        return this.heads.shrink();
    }

    public Lock writeLock() {
        return this.heads.writeLock();
    }

    protected void storageEngineFailure(Object failure) {
    }

    static class HeadMap<K>
    extends EvictionListeningReadWriteLockedOffHeapClockCache<K, InternalChain> {
        public HeadMap(EvictionListener<K, InternalChain> listener, PageSource source, ChainStorageEngine<K> chainStorage) {
            super(listener, source, chainStorage);
        }

        public Iterator<Map.Entry<K, InternalChain>> detachedEntryIterator() {
            Lock lock = this.readLock();
            lock.lock();
            try {
                AbstractLockedOffHeapHashMap.LockedEntryIterator lockedEntryIterator = new AbstractLockedOffHeapHashMap.LockedEntryIterator(){

                    protected Map.Entry<K, InternalChain> create(IntBuffer entry) {
                        Map.Entry attachedEntry = super.create(entry);
                        try (InternalChain chain = (InternalChain)attachedEntry.getValue();){
                            final Chain detachedChain = chain.detach();
                            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(attachedEntry.getKey(), new InternalChain(){

                                public Chain detach() {
                                    return detachedChain;
                                }

                                public boolean append(ByteBuffer element) {
                                    throw new UnsupportedOperationException();
                                }

                                public boolean replace(Chain expected, Chain replacement) {
                                    throw new UnsupportedOperationException();
                                }

                                public void close() {
                                }
                            });
                            return simpleImmutableEntry;
                        }
                    }
                };
                return lockedEntryIterator;
            }
            finally {
                lock.unlock();
            }
        }
    }

    static interface ChainMapEvictionListener<K> {
        public void onEviction(K var1, InternalChain var2);
    }
}

