/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.util.ChainBuilder;
import org.ehcache.clustered.server.offheap.ChainStorageEngine;
import org.ehcache.clustered.server.offheap.InternalChain;
import org.ehcache.clustered.server.offheap.OffHeapChainMap;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.BinaryStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.storage.portability.WriteContext;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapChainStorageEngine<K>
implements ChainStorageEngine<K>,
BinaryStorageEngine {
    private static final int ELEMENT_HEADER_SEQUENCE_OFFSET = 0;
    private static final int ELEMENT_HEADER_LENGTH_OFFSET = 8;
    private static final int ELEMENT_HEADER_NEXT_OFFSET = 12;
    private static final int ELEMENT_HEADER_SIZE = 20;
    private static final int CHAIN_HEADER_KEY_LENGTH_OFFSET = 0;
    private static final int CHAIN_HEADER_KEY_HASH_OFFSET = 4;
    private static final int CHAIN_HEADER_TAIL_OFFSET = 8;
    private static final int CHAIN_HEADER_SIZE = 16;
    private static final int DETACHED_CONTIGUOUS_CHAIN_ADDRESS_OFFSET = 0;
    private static final int DETACHED_CONTIGUOUS_CHAIN_HEADER_SIZE = 8;
    private final OffHeapStorageArea storage;
    private final Portability<? super K> keyPortability;
    private final Set<AttachedInternalChain> activeChains = Collections.newSetFromMap(new ConcurrentHashMap());
    private final int extendedChainHeaderSize;
    private final ByteBuffer emptyExtendedChainHeader;
    private final int totalChainHeaderSize;
    protected OffHeapChainMap.HeadMap<?> owner;
    private long nextSequenceNumber = 0L;
    private volatile boolean hasContiguousChains = false;

    public static <K> Factory<? extends ChainStorageEngine<K>> createFactory(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean thief, boolean victim) {
        return () -> new OffHeapChainStorageEngine(source, keyPortability, minPageSize, maxPageSize, thief, victim);
    }

    OffHeapChainStorageEngine(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean thief, boolean victim) {
        this(source, keyPortability, minPageSize, maxPageSize, thief, victim, ByteBuffer.allocate(0));
    }

    protected OffHeapChainStorageEngine(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean thief, boolean victim, ByteBuffer emptyExtendedChainHeader) {
        this.storage = new OffHeapStorageArea(PointerSize.LONG, (OffHeapStorageArea.Owner)new StorageOwner(), source, minPageSize, maxPageSize, thief, victim);
        this.keyPortability = keyPortability;
        this.extendedChainHeaderSize = emptyExtendedChainHeader.remaining();
        this.emptyExtendedChainHeader = emptyExtendedChainHeader;
        this.totalChainHeaderSize = 16 + this.extendedChainHeaderSize;
    }

    Set<AttachedInternalChain> getActiveChains() {
        return this.activeChains;
    }

    @Override
    public InternalChain newChain(ByteBuffer element) {
        return new GenesisLink(element);
    }

    @Override
    public InternalChain newChain(Chain chain) {
        return new GenesisLinks(chain);
    }

    public Long writeMapping(K key, InternalChain value, int hash, int metadata) {
        if (value instanceof GenesisChain) {
            return this.createAttachedChain(key, hash, (GenesisChain)value);
        }
        throw new AssertionError((Object)"only detached internal chains should be initially written");
    }

    public void attachedMapping(long encoding, int hash, int metadata) {
        this.chainAttached(encoding);
    }

    public void freeMapping(long encoding, int hash, boolean removal) {
        try (AttachedInternalChain chain = new AttachedInternalChain(encoding);){
            chain.free();
        }
    }

    public InternalChain readValue(long encoding) {
        return new AttachedInternalChain(encoding);
    }

    public boolean equalsValue(Object value, long encoding) {
        try (AttachedInternalChain chain = new AttachedInternalChain(encoding);){
            boolean bl = chain.equals(value);
            return bl;
        }
    }

    public K readKey(long encoding, int hashCode) {
        return (K)this.keyPortability.decode(this.readKeyBuffer(encoding));
    }

    public boolean equalsKey(Object key, long encoding) {
        return this.keyPortability.equals(key, this.readKeyBuffer(encoding));
    }

    private ByteBuffer readKeyBuffer(long encoding) {
        int keyLength = this.readKeySize(encoding);
        int elemLength = this.readElementLength(encoding + (long)this.totalChainHeaderSize);
        return this.storage.readBuffer(encoding + (long)this.totalChainHeaderSize + 20L + (long)elemLength, keyLength);
    }

    public int readKeyHash(long encoding) {
        return this.storage.readInt(encoding + 4L);
    }

    private int readElementLength(long element) {
        return Integer.MAX_VALUE & this.storage.readInt(element + 8L);
    }

    public ByteBuffer readBinaryKey(long encoding) {
        return this.readKeyBuffer(encoding);
    }

    public ByteBuffer readBinaryValue(long chain) {
        long element = chain + (long)this.totalChainHeaderSize;
        int totalLength = 8;
        do {
            totalLength += 20 + this.readElementLength(element);
        } while ((element = this.storage.readLong(element + 12L)) != chain);
        ByteBuffer detachedContiguousBuffer = ByteBuffer.allocate(totalLength);
        detachedContiguousBuffer.putLong(chain);
        element = chain + (long)this.totalChainHeaderSize;
        do {
            int startPosition = detachedContiguousBuffer.position();
            detachedContiguousBuffer.put(this.storage.readBuffer(element, 20 + this.readElementLength(element)));
            detachedContiguousBuffer.mark();
            detachedContiguousBuffer.putLong(startPosition + 12, -1L);
            detachedContiguousBuffer.reset();
        } while ((element = this.storage.readLong(element + 12L)) != chain);
        return (ByteBuffer)detachedContiguousBuffer.flip();
    }

    public boolean equalsBinaryKey(ByteBuffer binaryKey, long chain) {
        return binaryKey.equals(this.readKeyBuffer(chain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long writeBinaryMapping(ByteBuffer binaryKey, ByteBuffer binaryValue, int hash, int metadata) {
        int totalSize = binaryKey.remaining() + (binaryValue.remaining() - 8) + this.totalChainHeaderSize;
        long chain = this.storage.allocate((long)totalSize);
        if (chain < 0L) {
            return null;
        }
        if (binaryValue.remaining() < 28) {
            throw new AssertionError((Object)"Invalid chain data detected. Empty links");
        }
        binaryValue.mark();
        binaryKey.mark();
        try {
            binaryValue.position(8);
            ByteBuffer firstElementWithHeader = binaryValue.slice();
            int firstElementWithHeaderSize = 20 + (Integer.MAX_VALUE & firstElementWithHeader.getInt(8));
            firstElementWithHeader.limit(firstElementWithHeaderSize);
            binaryValue.position(binaryValue.position() + firstElementWithHeaderSize);
            int keySize = binaryKey.remaining();
            long firstElementLocation = chain + (long)this.totalChainHeaderSize;
            long keyLocation = firstElementLocation + (long)firstElementWithHeaderSize;
            long restOfElementsLocation = keyLocation + (long)keySize;
            ByteBuffer restOfElementsBuffer = binaryValue.slice();
            ArrayList<Integer> restOfElementLengthsWithHeader = new ArrayList<Integer>();
            while (restOfElementsBuffer.hasRemaining()) {
                int skipLength = 20 + (Integer.MAX_VALUE & restOfElementsBuffer.getInt(restOfElementsBuffer.position() + 8));
                restOfElementLengthsWithHeader.add(skipLength);
                restOfElementsBuffer.position(restOfElementsBuffer.position() + skipLength);
            }
            restOfElementsBuffer.rewind();
            this.storage.writeInt(chain + 4L, hash);
            this.storage.writeInt(chain + 0L, Integer.MIN_VALUE | keySize);
            this.storage.writeBuffer(keyLocation, binaryKey);
            this.storage.writeBuffer(firstElementLocation, firstElementWithHeader);
            this.storage.writeBuffer(chain + 16L, this.emptyExtendedChainHeader.duplicate());
            if (restOfElementsBuffer.hasRemaining()) {
                this.storage.writeBuffer(restOfElementsLocation, restOfElementsBuffer);
            }
            if (restOfElementLengthsWithHeader.size() <= 0) {
                this.storage.writeLong(chain + 8L, firstElementLocation);
                this.storage.writeLong(firstElementLocation + 12L, chain);
            } else {
                int i;
                this.hasContiguousChains = true;
                this.storage.writeLong(firstElementLocation + 12L, restOfElementsLocation);
                long currentLocation = restOfElementsLocation;
                for (i = 0; i < restOfElementLengthsWithHeader.size() - 1; ++i) {
                    int elemLength = (Integer)restOfElementLengthsWithHeader.get(i) - 20;
                    int adjustedLength = Integer.MIN_VALUE | elemLength;
                    long nextLocation = currentLocation + (long)elemLength + 20L;
                    this.storage.writeLong(currentLocation + 12L, nextLocation);
                    this.storage.writeInt(currentLocation + 8L, adjustedLength);
                    currentLocation = nextLocation;
                }
                int adjustedLength = Integer.MIN_VALUE | (Integer)restOfElementLengthsWithHeader.get(i) - 20;
                this.storage.writeLong(currentLocation + 12L, chain);
                this.storage.writeInt(currentLocation + 8L, adjustedLength);
                this.storage.writeLong(chain + 8L, currentLocation);
            }
            Long l = chain;
            return l;
        }
        finally {
            binaryKey.reset();
            binaryValue.reset();
        }
    }

    public static long extractChainAddressFromValue(ByteBuffer valueBuffer) {
        return valueBuffer.getLong(0);
    }

    public Long writeBinaryMapping(ByteBuffer[] byteBuffers, ByteBuffer[] byteBuffers1, int i, int i1) {
        throw new AssertionError((Object)"Operation Not supported");
    }

    private int readKeySize(long encoding) {
        return Integer.MAX_VALUE & this.storage.readInt(encoding + 0L);
    }

    public void clear() {
        this.storage.clear();
    }

    public long getAllocatedMemory() {
        return this.storage.getAllocatedMemory();
    }

    public long getOccupiedMemory() {
        return this.storage.getOccupiedMemory();
    }

    public long getVitalMemory() {
        return this.getOccupiedMemory();
    }

    public long getDataSize() {
        return this.storage.getAllocatedMemory();
    }

    public void invalidateCache() {
    }

    public void bind(StorageEngine.Owner owner) {
        if (!(owner instanceof OffHeapChainMap.HeadMap)) {
            throw new IllegalArgumentException("Chain storage engine owner must be an OffHeapChainMap.HeadMap (was " + owner.getClass() + ")");
        }
        this.owner = (OffHeapChainMap.HeadMap)owner;
    }

    public void destroy() {
        this.storage.destroy();
    }

    public boolean shrink() {
        return this.storage.shrink();
    }

    protected ByteBuffer getExtensionHeader(long chainAddress) {
        this.checkExtensionHeaderExists();
        return this.storage.readBuffer(this.toExtensionAddress(chainAddress), this.extendedChainHeaderSize);
    }

    protected WriteContext getExtensionWriteContext(final long chainAddress) {
        this.checkExtensionHeaderExists();
        return new WriteContext(){

            public void setLong(int offset, long value) {
                if (offset < 0 || offset >= OffHeapChainStorageEngine.this.extendedChainHeaderSize) {
                    throw new IllegalArgumentException("Offset not within bounds 0 >= " + offset + " < " + OffHeapChainStorageEngine.this.extendedChainHeaderSize);
                }
                OffHeapChainStorageEngine.this.storage.writeLong(OffHeapChainStorageEngine.this.toExtensionAddress(chainAddress) + (long)offset, value);
            }

            public void flush() {
            }
        };
    }

    protected void chainAttached(long chainAddress) {
    }

    protected void chainFreed(long chainAddress) {
    }

    protected void chainModified(long chainAddress) {
    }

    protected void chainMoved(long fromChainAddress, long toChainAddress) {
    }

    private void checkExtensionHeaderExists() {
        if (this.extendedChainHeaderSize <= 0) {
            throw new AssertionError((Object)"No extended header support for this storage engine");
        }
    }

    private long toExtensionAddress(long chainAddress) {
        return chainAddress + 16L;
    }

    private long writeElement(long address, ByteBuffer element) {
        this.storage.writeLong(address + 0L, this.nextSequenceNumber++);
        this.storage.writeInt(address + 8L, element.remaining());
        this.storage.writeBuffer(address + 20L, element.duplicate());
        return address;
    }

    private Long createAttachedChain(K key, int hash, GenesisChain value) {
        ByteBuffer keyBuffer = this.keyPortability.encode(key);
        return this.createAttachedChain(keyBuffer, hash, value.iterator());
    }

    private Long createAttachedChain(ByteBuffer keyBuffer, int hash, ByteBuffer elemBuffer) {
        long chain = this.storage.allocate((long)(keyBuffer.remaining() + elemBuffer.remaining() + this.totalChainHeaderSize + 20));
        if (chain < 0L) {
            return null;
        }
        int keySize = keyBuffer.remaining();
        this.storage.writeInt(chain + 4L, hash);
        this.storage.writeInt(chain + 0L, Integer.MIN_VALUE | keySize);
        this.storage.writeBuffer(chain + (long)this.totalChainHeaderSize + 20L + (long)elemBuffer.remaining(), keyBuffer);
        if (this.extendedChainHeaderSize > 0) {
            this.storage.writeBuffer(chain + 16L, this.emptyExtendedChainHeader.duplicate());
        }
        long element = chain + (long)this.totalChainHeaderSize;
        this.writeElement(element, elemBuffer);
        this.storage.writeLong(element + 12L, chain);
        this.storage.writeLong(chain + 8L, element);
        return chain;
    }

    private Long createAttachedChain(ByteBuffer readKeyBuffer, int hash, Iterator<Element> iterator) {
        Long address = this.createAttachedChain(readKeyBuffer, hash, iterator.next().getPayload());
        if (address == null) {
            return null;
        }
        if (iterator.hasNext()) {
            try (AttachedInternalChain chain = new AttachedInternalChain(address);){
                do {
                    if (chain.append(iterator.next().getPayload())) continue;
                    chain.free();
                    Long l = null;
                    return l;
                } while (iterator.hasNext());
            }
        }
        return address;
    }

    private long findHead(long address) {
        while (!this.isHead(address)) {
            address = this.storage.readLong(address + 12L);
        }
        return address;
    }

    private boolean isHead(long address) {
        return this.storage.readInt(address + 0L) < 0;
    }

    class StorageOwner
    implements OffHeapStorageArea.Owner {
        StorageOwner() {
        }

        public Collection<Long> evictAtAddress(long address, boolean shrink) {
            ArrayList<Long> elements = new ArrayList<Long>();
            long chain = -1L;
            long element = address;
            do {
                elements.add(element);
                if (!OffHeapChainStorageEngine.this.isHead(element)) continue;
                chain = element;
                element += (long)OffHeapChainStorageEngine.this.totalChainHeaderSize;
            } while ((element = OffHeapChainStorageEngine.this.storage.readLong(element + 12L)) != address);
            for (AttachedInternalChain activeChain : OffHeapChainStorageEngine.this.activeChains) {
                if (activeChain.chain != chain) continue;
                return Collections.emptyList();
            }
            int hash = OffHeapChainStorageEngine.this.storage.readInt(chain + 4L);
            int slot = OffHeapChainStorageEngine.this.owner.getSlotForHashAndEncoding(hash, chain, -1L);
            if (OffHeapChainStorageEngine.this.owner.evict(slot, shrink)) {
                return elements;
            }
            return Collections.emptyList();
        }

        public Lock writeLock() {
            return OffHeapChainStorageEngine.this.owner.writeLock();
        }

        public boolean isThief() {
            return OffHeapChainStorageEngine.this.owner.isThiefForTableAllocations();
        }

        public boolean moved(long from, long to) {
            if (OffHeapChainStorageEngine.this.isHead(to)) {
                int hashCode = OffHeapChainStorageEngine.this.storage.readInt(to + 4L);
                if (!OffHeapChainStorageEngine.this.owner.updateEncoding(hashCode, from, to, -1L)) {
                    return false;
                }
                long tail = OffHeapChainStorageEngine.this.storage.readLong(to + 8L);
                if (tail == from + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize) {
                    tail = to + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize;
                    OffHeapChainStorageEngine.this.storage.writeLong(to + 8L, tail);
                }
                OffHeapChainStorageEngine.this.storage.writeLong(tail + 12L, to);
                for (AttachedInternalChain activeChain : OffHeapChainStorageEngine.this.activeChains) {
                    activeChain.moved(from, to);
                }
                return true;
            }
            long chain = OffHeapChainStorageEngine.this.findHead(to);
            long tail = OffHeapChainStorageEngine.this.storage.readLong(chain + 8L);
            if (tail == from) {
                OffHeapChainStorageEngine.this.storage.writeLong(chain + 8L, to);
            }
            long element = chain + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize;
            while (element != chain) {
                long next = OffHeapChainStorageEngine.this.storage.readLong(element + 12L);
                if (next == from) {
                    OffHeapChainStorageEngine.this.storage.writeLong(element + 12L, to);
                    return true;
                }
                element = next;
            }
            throw new AssertionError();
        }

        public int sizeOf(long address) {
            if (OffHeapChainStorageEngine.this.isHead(address)) {
                int keySize = OffHeapChainStorageEngine.this.readKeySize(address);
                return keySize + OffHeapChainStorageEngine.this.totalChainHeaderSize + this.sizeOf(address + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize);
            }
            int elementSize = OffHeapChainStorageEngine.this.readElementLength(address);
            return 20 + elementSize;
        }
    }

    private final class AttachedInternalChain
    implements InternalChain {
        private long chain;
        private boolean chainModified = false;

        AttachedInternalChain(long address) {
            this.chain = address;
            OffHeapChainStorageEngine.this.activeChains.add(this);
        }

        public Chain detach() {
            ArrayList<Element> buffers = new ArrayList<Element>();
            long element = this.chain + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize;
            do {
                buffers.add(this.element(this.readElementBuffer(element), this.readElementSequenceNumber(element)));
            } while ((element = OffHeapChainStorageEngine.this.storage.readLong(element + 12L)) != this.chain);
            return ChainBuilder.chainFromList(buffers);
        }

        public boolean append(ByteBuffer element) {
            long newTail = this.createElement(element);
            if (newTail < 0L) {
                return false;
            }
            this.chainModified = true;
            long oldTail = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L);
            OffHeapChainStorageEngine.this.storage.writeLong(newTail + 12L, this.chain);
            OffHeapChainStorageEngine.this.storage.writeLong(oldTail + 12L, newTail);
            OffHeapChainStorageEngine.this.storage.writeLong(this.chain + 8L, newTail);
            return true;
        }

        public boolean replace(Chain expected, Chain replacement) {
            if (expected.isEmpty()) {
                throw new IllegalArgumentException("Empty expected sequence");
            }
            if (replacement.isEmpty()) {
                return this.removeHeader(expected);
            }
            return this.replaceHeader(expected, replacement);
        }

        public boolean removeHeader(Chain expected) {
            long suffixHead = this.chain + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize;
            Iterator expectedIt = expected.iterator();
            do {
                if (!this.compare((Element)expectedIt.next(), suffixHead)) {
                    return true;
                }
                suffixHead = OffHeapChainStorageEngine.this.storage.readLong(suffixHead + 12L);
            } while (expectedIt.hasNext() && suffixHead != this.chain);
            if (expectedIt.hasNext()) {
                return true;
            }
            if (suffixHead == this.chain) {
                int slot = OffHeapChainStorageEngine.this.owner.getSlotForHashAndEncoding(OffHeapChainStorageEngine.this.readKeyHash(this.chain), this.chain, -1L);
                OffHeapChainStorageEngine.this.owner.removeAtSlot(slot, true);
                return true;
            }
            int hash = OffHeapChainStorageEngine.this.readKeyHash(this.chain);
            int elemSize = OffHeapChainStorageEngine.this.readElementLength(suffixHead);
            ByteBuffer elemBuffer = OffHeapChainStorageEngine.this.storage.readBuffer(suffixHead + 20L, elemSize);
            Long newChainAddress = OffHeapChainStorageEngine.this.createAttachedChain(OffHeapChainStorageEngine.this.readKeyBuffer(this.chain), hash, elemBuffer);
            if (newChainAddress == null) {
                return false;
            }
            Throwable throwable = null;
            try (AttachedInternalChain newChain = new AttachedInternalChain(newChainAddress);){
                newChain.chainModified = true;
                long next = OffHeapChainStorageEngine.this.storage.readLong(suffixHead + 12L);
                long tail = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L);
                if (next != this.chain) {
                    newChain.append(next, tail);
                }
                if (OffHeapChainStorageEngine.this.owner.updateEncoding(hash, this.chain, newChainAddress, -1L)) {
                    OffHeapChainStorageEngine.this.storage.writeLong(suffixHead + 12L, this.chain);
                    OffHeapChainStorageEngine.this.storage.writeLong(this.chain + 8L, suffixHead);
                    OffHeapChainStorageEngine.this.chainMoved(this.chain, newChainAddress);
                    this.free();
                    boolean bl = true;
                    return bl;
                }
                try {
                    newChain.free();
                    throw new AssertionError((Object)"Encoding update failure - impossible!");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        public boolean replaceHeader(Chain expected, Chain replacement) {
            long prefixTail;
            long suffixHead = this.chain + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize;
            Iterator expectedIt = expected.iterator();
            do {
                if (!this.compare((Element)expectedIt.next(), suffixHead)) {
                    return true;
                }
                prefixTail = suffixHead;
                suffixHead = OffHeapChainStorageEngine.this.storage.readLong(suffixHead + 12L);
            } while (expectedIt.hasNext() && suffixHead != this.chain);
            if (expectedIt.hasNext()) {
                return true;
            }
            int hash = OffHeapChainStorageEngine.this.readKeyHash(this.chain);
            Long newChainAddress = OffHeapChainStorageEngine.this.createAttachedChain(OffHeapChainStorageEngine.this.readKeyBuffer(this.chain), hash, replacement.iterator());
            if (newChainAddress == null) {
                return false;
            }
            Throwable throwable = null;
            try (AttachedInternalChain newChain = new AttachedInternalChain(newChainAddress);){
                newChain.chainModified = true;
                if (suffixHead != this.chain) {
                    newChain.append(suffixHead, OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L));
                }
                if (OffHeapChainStorageEngine.this.owner.updateEncoding(hash, this.chain, newChainAddress, -1L)) {
                    OffHeapChainStorageEngine.this.storage.writeLong(prefixTail + 12L, this.chain);
                    OffHeapChainStorageEngine.this.chainMoved(this.chain, newChainAddress);
                    this.free();
                    boolean bl = true;
                    return bl;
                }
                try {
                    newChain.free();
                    throw new AssertionError((Object)"Encoding update failure - impossible!");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        private void free() {
            OffHeapChainStorageEngine.this.chainFreed(this.chain);
            this.chainModified = false;
            long element = OffHeapChainStorageEngine.this.storage.readLong(this.chain + (long)OffHeapChainStorageEngine.this.totalChainHeaderSize + 12L);
            while (element != this.chain) {
                long next = OffHeapChainStorageEngine.this.storage.readLong(element + 12L);
                if (OffHeapChainStorageEngine.this.storage.readInt(element + 8L) >= 0) {
                    OffHeapChainStorageEngine.this.storage.free(element);
                }
                element = next;
            }
            OffHeapChainStorageEngine.this.storage.free(this.chain);
        }

        private long createElement(ByteBuffer element) {
            long newElement = OffHeapChainStorageEngine.this.storage.allocate((long)(element.remaining() + 20));
            if (newElement < 0L) {
                return newElement;
            }
            OffHeapChainStorageEngine.this.writeElement(newElement, element);
            return newElement;
        }

        private boolean compare(Element element, long address) {
            if (element instanceof SequencedElement) {
                return this.readElementSequenceNumber(address) == ((SequencedElement)element).getSequenceNumber();
            }
            return this.readElementBuffer(address).equals(element.getPayload());
        }

        private void append(long head, long tail) {
            long oldTail = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L);
            OffHeapChainStorageEngine.this.storage.writeLong(oldTail + 12L, head);
            OffHeapChainStorageEngine.this.storage.writeLong(tail + 12L, this.chain);
            OffHeapChainStorageEngine.this.storage.writeLong(this.chain + 8L, tail);
            if (OffHeapChainStorageEngine.this.hasContiguousChains) {
                long current = head;
                long prev = oldTail;
                while (current != this.chain) {
                    long next = OffHeapChainStorageEngine.this.storage.readLong(current + 12L);
                    int elemLength = OffHeapChainStorageEngine.this.storage.readInt(current + 8L);
                    if (elemLength < 0) {
                        int elemLengthWithHeader = (Integer.MAX_VALUE & elemLength) + 20;
                        long element = OffHeapChainStorageEngine.this.storage.allocate((long)elemLengthWithHeader);
                        OffHeapChainStorageEngine.this.storage.writeBuffer(element, OffHeapChainStorageEngine.this.storage.readBuffer(current, elemLengthWithHeader));
                        OffHeapChainStorageEngine.this.storage.writeInt(element + 8L, elemLengthWithHeader - 20);
                        OffHeapChainStorageEngine.this.storage.writeLong(prev + 12L, element);
                        prev = element;
                    } else {
                        prev = current;
                    }
                    current = next;
                }
                OffHeapChainStorageEngine.this.storage.writeLong(this.chain + 8L, prev);
            }
        }

        private Element element(ByteBuffer attachedBuffer, final long sequence) {
            final ByteBuffer detachedBuffer = (ByteBuffer)ByteBuffer.allocate(attachedBuffer.remaining()).put(attachedBuffer).flip();
            return new SequencedElement(){

                public ByteBuffer getPayload() {
                    return detachedBuffer.asReadOnlyBuffer();
                }

                public long getSequenceNumber() {
                    return sequence;
                }
            };
        }

        private ByteBuffer readElementBuffer(long address) {
            int elemLength = OffHeapChainStorageEngine.this.readElementLength(address);
            return OffHeapChainStorageEngine.this.storage.readBuffer(address + 20L, elemLength);
        }

        private long readElementSequenceNumber(long address) {
            return OffHeapChainStorageEngine.this.storage.readLong(address + 0L);
        }

        public void moved(long from, long to) {
            if (from == this.chain) {
                this.chain = to;
                if (from != to) {
                    OffHeapChainStorageEngine.this.chainMoved(from, to);
                }
            }
        }

        public void close() {
            try {
                if (this.chainModified) {
                    this.chainModified = false;
                    OffHeapChainStorageEngine.this.chainModified(this.chain);
                }
            }
            finally {
                OffHeapChainStorageEngine.this.activeChains.remove(this);
            }
        }
    }

    private static class GenesisLinks
    extends GenesisChain {
        private final Chain chain;

        public GenesisLinks(Chain chain) {
            this.chain = chain;
        }

        @Override
        protected Iterator<Element> iterator() {
            return this.chain.iterator();
        }
    }

    private static class GenesisLink
    extends GenesisChain {
        private final Element element = buffer::asReadOnlyBuffer;

        public GenesisLink(ByteBuffer buffer) {
        }

        @Override
        protected Iterator<Element> iterator() {
            return Collections.singleton(this.element).iterator();
        }
    }

    private static abstract class GenesisChain
    implements InternalChain {
        private GenesisChain() {
        }

        public Chain detach() {
            throw new AssertionError((Object)"Chain not in storage yet. Cannot be detached");
        }

        public boolean append(ByteBuffer element) {
            throw new AssertionError((Object)"Chain not in storage yet. Cannot be appended");
        }

        public boolean replace(Chain expected, Chain replacement) {
            throw new AssertionError((Object)"Chain not in storage yet. Cannot be mutated");
        }

        public void close() {
        }

        protected abstract Iterator<Element> iterator();
    }
}

