/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.repo;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheStateRepoSyncMessage;

class ServerStateRepository {
    private final ConcurrentMap<String, ConcurrentMap<Object, Object>> concurrentMapRepo = new ConcurrentHashMap<String, ConcurrentMap<Object, Object>>();

    ServerStateRepository() {
    }

    EhcacheEntityResponse invoke(StateRepositoryOpMessage message) {
        Object result;
        String mapId = message.getMapId();
        ConcurrentMap<Object, Object> map = this.getStateMap(mapId);
        switch (message.getMessageType()) {
            case GET_STATE_REPO: {
                StateRepositoryOpMessage.GetMessage getMessage = (StateRepositoryOpMessage.GetMessage)message;
                result = map.get(getMessage.getKey());
                break;
            }
            case PUT_IF_ABSENT: {
                StateRepositoryOpMessage.PutIfAbsentMessage putIfAbsentMessage = (StateRepositoryOpMessage.PutIfAbsentMessage)message;
                result = map.putIfAbsent(putIfAbsentMessage.getKey(), putIfAbsentMessage.getValue());
                break;
            }
            case ENTRY_SET: {
                result = map.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue())).collect(Collectors.toSet());
                break;
            }
            case REMOVE: {
                StateRepositoryOpMessage.RemoveMessage removeMessage = (StateRepositoryOpMessage.RemoveMessage)message;
                result = map.remove(removeMessage.getKey(), removeMessage.getValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported operation: " + message.getMessageType()));
            }
        }
        return EhcacheEntityResponse.mapValue(result);
    }

    private ConcurrentMap<Object, Object> getStateMap(String mapId) {
        ConcurrentHashMap newMap;
        ConcurrentHashMap map = (ConcurrentHashMap)this.concurrentMapRepo.get(mapId);
        if (map == null && (map = (ConcurrentMap)this.concurrentMapRepo.putIfAbsent(mapId, newMap = new ConcurrentHashMap())) == null) {
            map = newMap;
        }
        return map;
    }

    List<EhcacheStateRepoSyncMessage> syncMessage(String cacheId) {
        ArrayList<EhcacheStateRepoSyncMessage> result = new ArrayList<EhcacheStateRepoSyncMessage>();
        for (Map.Entry entry : this.concurrentMapRepo.entrySet()) {
            result.add(new EhcacheStateRepoSyncMessage(cacheId, (String)entry.getKey(), (ConcurrentMap)entry.getValue()));
        }
        return result;
    }

    void processSyncMessage(EhcacheStateRepoSyncMessage stateRepoSyncMessage) {
        this.concurrentMapRepo.put(stateRepoSyncMessage.getMapId(), stateRepoSyncMessage.getMappings());
    }
}

