/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.server.ClusterTierManagerDump;
import org.ehcache.clustered.server.management.Management;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.InvokeContext;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.StateDumpCollector;

public class ClusterTierManagerPassiveEntity
implements PassiveServerEntity<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagerPassiveEntity.class);
    private final EhcacheStateService ehcacheStateService;
    private final Management management;
    private final ClusterTierManagerConfiguration configuration;

    public ClusterTierManagerPassiveEntity(ClusterTierManagerConfiguration config, EhcacheStateService ehcacheStateService, Management management) throws ConfigurationException {
        if (config == null) {
            throw new ConfigurationException("ClusterTierManagerConfiguration cannot be null");
        }
        this.ehcacheStateService = ehcacheStateService;
        this.configuration = config;
        if (ehcacheStateService == null) {
            throw new AssertionError((Object)"Server failed to retrieve EhcacheStateService.");
        }
        try {
            ehcacheStateService.configure();
            this.management = management;
        }
        catch (ConfigurationException e) {
            ehcacheStateService.destroy();
            throw e;
        }
    }

    public void addStateTo(StateDumpCollector dump) {
        ClusterTierManagerDump.dump(dump, this.configuration);
    }

    public void invokePassive(InvokeContext context, EhcacheEntityMessage message) {
        if (message instanceof EhcacheOperationMessage) {
            EhcacheOperationMessage operationMessage = (EhcacheOperationMessage)message;
            EhcacheMessageType messageType = operationMessage.getMessageType();
            if (!EhcacheMessageType.isLifecycleMessage((EhcacheMessageType)messageType)) {
                throw new AssertionError((Object)("Unsupported EhcacheOperationMessage: " + operationMessage.getMessageType()));
            }
        } else {
            throw new AssertionError((Object)("Unsupported EhcacheEntityMessage: " + message.getClass()));
        }
        this.invokeLifeCycleOperation((LifecycleMessage)message);
    }

    private void invokeLifeCycleOperation(LifecycleMessage message) {
        switch (message.getMessageType()) {
            case PREPARE_FOR_DESTROY: {
                this.ehcacheStateService.prepareForDestroy();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported LifeCycle operation " + message.getMessageType()));
            }
        }
    }

    public void startSyncEntity() {
        LOGGER.info("Sync started.");
    }

    public void endSyncEntity() {
        LOGGER.info("Sync completed.");
    }

    public void startSyncConcurrencyKey(int concurrencyKey) {
        LOGGER.info("Sync started for concurrency key {}.", (Object)concurrencyKey);
    }

    public void endSyncConcurrencyKey(int concurrencyKey) {
        LOGGER.info("Sync complete for concurrency key {}.", (Object)concurrencyKey);
    }

    public void createNew() {
        this.management.entityCreated();
        this.management.sharedPoolsConfigured();
    }

    public void destroy() {
        this.ehcacheStateService.destroy();
        this.management.close();
    }
}

