/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import java.util.ArrayList;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.ehcache.jcache.JCache;
import org.ehcache.jcache.JCacheEntryEventAdapter;

public class JCacheListenerAdapter<K, V>
implements CacheEventListener {
    private final CacheEntryListener<K, V> cacheListener;
    private final CacheEntryEventFilter<? super K, ? super V> cacheEntryEventFilter;
    private final JCache<K, V> jCache;
    private final boolean removedListener;
    private final boolean createdListener;
    private final boolean updatedListener;
    private final boolean expiredListener;
    private final boolean oldValueRequired;
    private final boolean synchronous;

    public JCacheListenerAdapter(CacheEntryListener<K, V> cacheListener, JCache<K, V> jCache, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.cacheListener = cacheListener;
        this.jCache = jCache;
        this.removedListener = this.implementsMethods(CacheEntryRemovedListener.class);
        this.createdListener = this.implementsMethods(CacheEntryCreatedListener.class);
        this.updatedListener = this.implementsMethods(CacheEntryUpdatedListener.class);
        this.expiredListener = this.implementsMethods(CacheEntryExpiredListener.class);
        this.oldValueRequired = cacheEntryListenerConfiguration.isOldValueRequired();
        this.synchronous = cacheEntryListenerConfiguration.isSynchronous();
        this.cacheEntryEventFilter = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory() != null ? (CacheEntryEventFilter)cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory().create() : null;
    }

    private boolean implementsMethods(Class cls) {
        return cls.isAssignableFrom(this.cacheListener.getClass());
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        JCacheEntryEventAdapter<K, V> e;
        if (this.removedListener && this.evaluate(e = new JCacheEntryEventAdapter<K, V>(this.jCache, element, EventType.REMOVED))) {
            ArrayList<JCacheEntryEventAdapter<K, V>> arrayList = new ArrayList<JCacheEntryEventAdapter<K, V>>();
            arrayList.add(e);
            if (element != null) {
                ((CacheEntryRemovedListener)this.cacheListener).onRemoved(arrayList);
            }
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        JCacheEntryEventAdapter<K, V> e;
        if (this.createdListener && this.evaluate(e = new JCacheEntryEventAdapter<K, V>(this.jCache, element, EventType.CREATED))) {
            ArrayList<JCacheEntryEventAdapter<K, V>> arrayList = new ArrayList<JCacheEntryEventAdapter<K, V>>();
            arrayList.add(e);
            if (element != null) {
                ((CacheEntryCreatedListener)this.cacheListener).onCreated(arrayList);
            }
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        JCacheEntryEventAdapter<K, V> e;
        if (this.updatedListener && this.evaluate(e = new JCacheEntryEventAdapter<K, V>(this.jCache, element, EventType.UPDATED))) {
            ArrayList<JCacheEntryEventAdapter<K, V>> arrayList = new ArrayList<JCacheEntryEventAdapter<K, V>>();
            arrayList.add(e);
            if (element != null) {
                ((CacheEntryUpdatedListener)this.cacheListener).onUpdated(arrayList);
            }
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        JCacheEntryEventAdapter<K, V> e;
        if (this.expiredListener && this.evaluate(e = new JCacheEntryEventAdapter<K, V>(this.jCache, element, EventType.EXPIRED))) {
            ArrayList<JCacheEntryEventAdapter<K, V>> arrayList = new ArrayList<JCacheEntryEventAdapter<K, V>>();
            arrayList.add(e);
            if (element != null) {
                ((CacheEntryExpiredListener)this.cacheListener).onExpired(arrayList);
            }
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        JCacheEntryEventAdapter<K, V> e;
        if (this.expiredListener && this.evaluate(e = new JCacheEntryEventAdapter<K, V>(this.jCache, element, EventType.REMOVED))) {
            ArrayList<JCacheEntryEventAdapter<K, V>> arrayList = new ArrayList<JCacheEntryEventAdapter<K, V>>();
            arrayList.add(e);
            if (element != null) {
                ((CacheEntryExpiredListener)this.cacheListener).onExpired(arrayList);
            }
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCacheListenerAdapter that = (JCacheListenerAdapter)o;
        if (this.createdListener != that.createdListener) {
            return false;
        }
        if (this.expiredListener != that.expiredListener) {
            return false;
        }
        if (this.removedListener != that.removedListener) {
            return false;
        }
        if (this.updatedListener != that.updatedListener) {
            return false;
        }
        return this.cacheListener.equals(that.cacheListener);
    }

    public int hashCode() {
        int result = this.cacheListener.hashCode();
        result = 31 * result + (this.removedListener ? 1 : 0);
        result = 31 * result + (this.createdListener ? 1 : 0);
        result = 31 * result + (this.updatedListener ? 1 : 0);
        result = 31 * result + (this.expiredListener ? 1 : 0);
        return result;
    }

    private boolean evaluate(JCacheEntryEventAdapter<K, V> entry) {
        return this.cacheEntryEventFilter == null || this.cacheEntryEventFilter.evaluate(entry);
    }
}

