/*
 * Decompiled with CFR 0.152.
 */
package com.tc.io;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCDataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;

public class TCByteBufferInputStream
extends InputStream
implements TCByteBufferInput {
    private static final int EOF = -1;
    private static final TCByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new TCByteBuffer[0];
    private TCByteBuffer[] data;
    private int totalLength;
    private int numBufs;
    private boolean closed = false;
    private int position = 0;
    private int index = 0;
    private boolean marked = false;

    private TCByteBufferInputStream(TCByteBuffer[] sourceData, int dupeLength, int sourceIndex) {
        this(sourceData, dupeLength, sourceIndex, true);
    }

    public TCByteBufferInputStream(TCByteBuffer data) {
        this(new TCByteBuffer[]{data});
    }

    public TCByteBufferInputStream(TCByteBuffer[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        long length = 0L;
        this.data = new TCByteBuffer[data.length];
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            TCByteBuffer buf = data[i];
            if (buf == null) {
                throw new NullPointerException("null buffer at index " + i);
            }
            this.data[i] = buf.duplicate().rewind();
            length += (long)buf.limit();
        }
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("too much data: " + length);
        }
        this.numBufs = this.data.length;
        this.totalLength = (int)length;
    }

    private TCByteBufferInputStream(TCByteBuffer[] sourceData, int dupeLength, int sourceIndex, boolean duplicate) {
        this.data = duplicate ? new TCByteBuffer[sourceData.length - sourceIndex] : sourceData;
        this.numBufs = this.data.length;
        if (duplicate) {
            int n = this.data.length;
            for (int i = 0; i < n; ++i) {
                this.data[i] = sourceData[sourceIndex + i].duplicate();
            }
        }
        this.totalLength = dupeLength;
        this.position = 0;
        this.index = 0;
    }

    @Override
    public TCByteBufferInput duplicate() {
        this.checkClosed();
        return new TCByteBufferInputStream(this.data, this.available(), this.index);
    }

    @Override
    public TCByteBufferInput duplicateAndLimit(int limit) {
        this.checkClosed();
        if (limit > this.available()) {
            throw new IllegalArgumentException("Not enough data left in stream: " + limit + " > " + this.available());
        }
        if (limit == 0) {
            return new TCByteBufferInputStream(EMPTY_BYTE_BUFFER_ARRAY);
        }
        int numBytesNeeded = limit;
        int dataIndex = this.index;
        int lastLimit = -1;
        while (numBytesNeeded > 0) {
            TCByteBuffer buf = this.data[dataIndex];
            int numFromThisBuffer = Math.min(numBytesNeeded, buf.remaining());
            lastLimit = buf.position() + numFromThisBuffer;
            if ((numBytesNeeded -= numFromThisBuffer) <= 0) continue;
            ++dataIndex;
        }
        int size = dataIndex - this.index + 1;
        TCByteBuffer[] limitedData = new TCByteBuffer[size];
        int n = limitedData.length;
        for (int i = 0; i < n; ++i) {
            limitedData[i] = this.data[this.index + i].duplicate();
        }
        limitedData[limitedData.length - 1].limit(lastLimit);
        return new TCByteBufferInputStream(limitedData, limit, 0, false);
    }

    @Override
    public TCByteBuffer[] toArray() {
        this.checkClosed();
        if (this.available() == 0) {
            return EMPTY_BYTE_BUFFER_ARRAY;
        }
        TCByteBuffer[] rv = new TCByteBuffer[this.numBufs - this.index];
        rv[0] = this.data[this.index].slice();
        int n = rv.length;
        for (int i = 1; i < n; ++i) {
            rv[i] = this.data[this.index + i].duplicate();
        }
        return rv;
    }

    @Override
    public TCByteBuffer[] toArray(TCByteBufferInput.Mark s, TCByteBufferInput.Mark e) {
        this.checkClosed();
        TCMark start = this.validateMark(s);
        TCMark end = this.validateMark(e);
        if (start.getStreamPosition() > end.getStreamPosition()) {
            TCMark temp = end;
            end = start;
            start = temp;
        } else if (start.getStreamPosition() == end.getStreamPosition()) {
            return EMPTY_BYTE_BUFFER_ARRAY;
        }
        TCByteBuffer[] rv = new TCByteBuffer[end.getBufferIndex() - start.getBufferIndex() + 1];
        int i = start.getBufferIndex();
        int idx = 0;
        while (i <= end.getBufferIndex()) {
            rv[idx] = this.data[i].duplicate();
            rv[idx].position(0);
            ++i;
            ++idx;
        }
        rv[0].position(start.getBufferPosition());
        rv[rv.length - 1].limit(end.getBufferPosition());
        rv[0] = rv[0].slice();
        return rv;
    }

    @Override
    public TCDataInput limit(int limit) {
        this.checkClosed();
        if (this.available() < limit) {
            throw new IllegalArgumentException("Not enough data left in stream: " + limit + " > " + this.available());
        }
        ArrayList<TCByteBuffer> newData = new ArrayList<TCByteBuffer>();
        int num = limit;
        while (num > 0) {
            TCByteBuffer current = this.data[this.index];
            int avail = current.remaining();
            int take = Math.min(avail, num);
            if (take > 0) {
                newData.add(current.slice().limit(take));
                num -= take;
            }
            this.nextBuffer();
        }
        this.data = new TCByteBuffer[newData.size()];
        this.data = newData.toArray(this.data);
        this.numBufs = this.data.length;
        this.totalLength = limit;
        this.position = 0;
        this.index = 0;
        return this;
    }

    @Override
    public int getTotalLength() {
        return this.totalLength;
    }

    @Override
    public int available() {
        return this.totalLength - this.position;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.data = null;
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TCByteBufferInput.Mark mark() {
        this.checkClosed();
        this.marked = true;
        return new TCMark(this, this.index, this.data[this.index].position(), this.position);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public final int read(byte[] b, int off, int len) {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.available() == 0) {
            return -1;
        }
        int bytesRead = 0;
        int numToRead = Math.min(this.available(), len);
        while (this.index < this.numBufs) {
            TCByteBuffer buf = this.data[this.index];
            if (buf.hasRemaining()) {
                int read = Math.min(buf.remaining(), numToRead);
                buf.get(b, off, read);
                off += read;
                this.position += read;
                bytesRead += read;
                if ((numToRead -= read) == 0) break;
            }
            this.nextBuffer();
        }
        return bytesRead;
    }

    @Override
    public final int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public final TCByteBuffer read(int len) {
        this.checkClosed();
        if (len == 0) {
            return TCByteBufferFactory.getInstance(0);
        }
        if (this.available() == 0) {
            return TCByteBufferFactory.getInstance(0);
        }
        TCByteBuffer result = this.data[this.index];
        if (result.remaining() >= len) {
            TCByteBuffer send = result.slice();
            send.limit(len);
            result.position(result.position() + len);
            return send;
        }
        result = TCByteBufferFactory.getInstance(len);
        while (this.index < this.numBufs) {
            TCByteBuffer buf = this.data[this.index];
            if (buf.hasRemaining()) {
                int limit = buf.limit();
                buf.limit(Math.min(buf.position() + result.remaining(), limit));
                result.put(buf);
                buf.limit(limit);
            }
            if (!result.hasRemaining()) break;
            this.nextBuffer();
        }
        if (result.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        return result.flip();
    }

    @Override
    public final int read() {
        this.checkClosed();
        while (this.index < this.numBufs) {
            if (this.data[this.index].hasRemaining()) {
                ++this.position;
                return this.data[this.index].get() & 0xFF;
            }
            this.nextBuffer();
        }
        return -1;
    }

    private void nextBuffer() {
        if (!this.marked) {
            this.data[this.index] = null;
        }
        ++this.index;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tcReset(TCByteBufferInput.Mark m) {
        this.checkClosed();
        TCMark mark = this.validateMark(m);
        int rewindToIndex = mark.getBufferIndex();
        while (this.index > rewindToIndex) {
            this.data[this.index].position(0);
            --this.index;
        }
        this.index = rewindToIndex;
        this.data[rewindToIndex].position(mark.getBufferPosition());
        this.position = mark.getStreamPosition();
    }

    private TCMark validateMark(TCByteBufferInput.Mark m) {
        if (m == null) {
            throw new IllegalArgumentException("Mark is null");
        }
        if (!(m instanceof TCMark)) {
            throw new IllegalArgumentException("Illegal Mark type Exception");
        }
        TCMark mark = (TCMark)m;
        if (mark.getStream() != this) {
            throw new IllegalArgumentException("Mark is not from this stream");
        }
        return mark;
    }

    @Override
    public long skip(long skip) {
        this.checkClosed();
        if (skip > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("skip value too large: " + skip);
        }
        if (skip <= 0L || this.available() == 0) {
            return 0L;
        }
        int numToSkip = Math.min(this.available(), (int)skip);
        int bytesSkipped = 0;
        while (this.index < this.numBufs) {
            TCByteBuffer buf = this.data[this.index];
            int remaining = buf.remaining();
            if (remaining > 0) {
                int numToRead = Math.min(remaining, numToSkip);
                buf.position(buf.position() + numToRead);
                this.position += numToRead;
                bytesSkipped += numToRead;
                if ((numToSkip -= numToRead) == 0) break;
            }
            this.nextBuffer();
        }
        return bytesSkipped;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("stream is closed");
        }
    }

    @Override
    public final int readInt() throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read()) | (byte3 = this.read()) | (byte4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
    }

    @Override
    public final byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    @Override
    public final char readChar() throws IOException {
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((byte1 << 8) + (byte2 << 0));
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final long readLong() throws IOException {
        int byte8;
        int byte7;
        int byte6;
        int byte5;
        int byte4;
        int byte3;
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read()) | (byte3 = this.read()) | (byte4 = this.read()) | (byte5 = this.read()) | (byte6 = this.read()) | (byte7 = this.read()) | (byte8 = this.read())) < 0) {
            throw new EOFException();
        }
        return ((long)byte1 << 56) + ((long)(byte2 & 0xFF) << 48) + ((long)(byte3 & 0xFF) << 40) + ((long)(byte4 & 0xFF) << 32) + ((long)(byte5 & 0xFF) << 24) + (long)((byte6 & 0xFF) << 16) + (long)((byte7 & 0xFF) << 8) + (long)((byte8 & 0xFF) << 0);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final short readShort() throws IOException {
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((byte1 << 8) + (byte2 << 0));
    }

    @Override
    public final String readString() throws IOException {
        boolean isNull = this.readBoolean();
        if (isNull) {
            return null;
        }
        int utf = this.read();
        if (utf < 0) {
            throw new EOFException();
        }
        switch (utf) {
            case 0: {
                return this.readStringFromChars();
            }
            case 1: {
                return DataInputStream.readUTF(this);
            }
        }
        throw new AssertionError((Object)("utf = " + utf));
    }

    private String readStringFromChars() throws IOException {
        int len = this.readInt();
        if (len == 0) {
            return "";
        }
        char[] chars = new char[len];
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) {
        return (int)this.skip(n);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (byte1 << 8) + (byte2 << 0);
    }

    @Override
    public final String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.readString();
    }

    private static class TCMark
    implements TCByteBufferInput.Mark {
        private final int bufferPosition;
        private final int bufferIndex;
        private final int streamPosition;
        private final TCByteBufferInputStream stream;

        TCMark(TCByteBufferInputStream stream, int bufferIndex, int bufferPosition, int streamPosition) {
            this.stream = stream;
            this.bufferIndex = bufferIndex;
            this.bufferPosition = bufferPosition;
            this.streamPosition = streamPosition;
        }

        public TCByteBufferInputStream getStream() {
            return this.stream;
        }

        int getBufferIndex() {
            return this.bufferIndex;
        }

        int getBufferPosition() {
            return this.bufferPosition;
        }

        int getStreamPosition() {
            return this.streamPosition;
        }

        public String toString() {
            return "Mark[TCByteBufferInputStream@" + System.identityHashCode(this.stream) + "] { Stream position : " + this.streamPosition + ", Buffer Index : " + this.bufferIndex + ", Buffer position : " + this.bufferPosition + " }";
        }
    }
}

