/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

class Util {
    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] extract(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            int read = 0;
            while ((read = in.read(data, 0, data.length)) > 0) {
                out.write(data, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Util.closeQuietly(in);
        }
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

