/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.internal.config.ClusteredResourcePoolImpl;
import org.ehcache.clustered.client.internal.config.DedicatedClusteredResourcePoolImpl;
import org.ehcache.clustered.client.internal.config.SharedClusteredResourcePoolImpl;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class ClusteredResourceConfigurationParser
implements CacheResourceConfigurationParser {
    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    public ResourcePool parseResourceConfiguration(Element fragment) {
        String elementName = fragment.getLocalName();
        if ("clustered-shared".equals(elementName)) {
            String sharing = fragment.getAttribute("sharing");
            return new SharedClusteredResourcePoolImpl(sharing);
        }
        if ("clustered-dedicated".equals(elementName)) {
            long size;
            String sizeValue;
            MemoryUnit sizeUnits;
            Attr fromAttr = fragment.getAttributeNode("from");
            String from = fromAttr == null ? null : fromAttr.getValue();
            String unitValue = fragment.getAttribute("unit").toUpperCase();
            try {
                sizeUnits = MemoryUnit.valueOf((String)unitValue);
            }
            catch (IllegalArgumentException e) {
                throw new XmlConfigurationException(String.format("XML configuration element <%s> 'unit' attribute '%s' is not valid", elementName, unitValue), (Throwable)e);
            }
            try {
                sizeValue = fragment.getFirstChild().getNodeValue();
            }
            catch (DOMException e) {
                throw new XmlConfigurationException(String.format("XML configuration element <%s> value is not valid", elementName), (Throwable)e);
            }
            try {
                size = Long.parseLong(sizeValue);
            }
            catch (NumberFormatException e) {
                throw new XmlConfigurationException(String.format("XML configuration element <%s> value '%s' is not valid", elementName, sizeValue), (Throwable)e);
            }
            return new DedicatedClusteredResourcePoolImpl(from, size, sizeUnits);
        }
        if ("clustered".equals(elementName)) {
            return new ClusteredResourcePoolImpl();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }
}

