/*
 * Decompiled with CFR 0.152.
 */
package com.tc.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class StreamAppender {
    private final PrintWriter output;
    private Thread outWriter;
    private Thread errWriter;

    public StreamAppender(OutputStream output) {
        this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output)), true);
    }

    public void writeInput(final InputStream err, final InputStream out) {
        this.errWriter = new Thread(){
            BufferedReader reader;
            {
                this.reader = new BufferedReader(new InputStreamReader(err));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        StreamAppender.this.output.println(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    StreamAppender.this.output.flush();
                }
            }
        };
        this.outWriter = new Thread(){
            BufferedReader reader;
            {
                this.reader = new BufferedReader(new InputStreamReader(out));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        StreamAppender.this.output.println(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    StreamAppender.this.output.flush();
                }
            }
        };
        this.errWriter.setDaemon(true);
        this.outWriter.setDaemon(true);
        this.errWriter.start();
        this.outWriter.start();
    }

    public void finish() throws Exception {
        this.outWriter.join();
        this.errWriter.join();
    }
}

