/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.io.TCDataInput;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.compression.CompressedData;
import com.tc.object.compression.StringCompressionUtil;
import com.tc.object.dna.impl.BaseDNAEncodingImpl;
import com.tc.object.loaders.ClassProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ApplicatorDNAEncodingImpl
extends BaseDNAEncodingImpl {
    private static final TCLogger logger = TCLogging.getLogger(ApplicatorDNAEncodingImpl.class);

    public ApplicatorDNAEncodingImpl(ClassProvider classProvider) {
        super(classProvider);
    }

    @Override
    protected boolean useStringEnumRead(byte type) {
        return true;
    }

    @Override
    protected boolean useClassProvider(byte type, byte typeToCheck) {
        return true;
    }

    @Override
    protected boolean useUTF8String(byte type) {
        return true;
    }

    @Override
    protected Object readCompressedString(TCDataInput input) throws IOException {
        int uncompressedByteLength = input.readInt();
        byte[] data = this.readByteArray(input);
        int stringLength = input.readInt();
        int stringHash = input.readInt();
        char[] compressedChars = StringCompressionUtil.packCompressed(new CompressedData(data, uncompressedByteLength));
        String s = this.constructCompressedString(compressedChars, stringLength, stringHash);
        if (STRING_COMPRESSION_LOGGING_ENABLED) {
            logger.info("Read compressed String of compressed size : " + compressedChars.length + ", uncompressed size : " + stringLength + ", hash code : " + stringHash);
        }
        return s;
    }

    private String constructCompressedString(char[] compressedChars, int stringLength, int stringHash) {
        byte[] utf8bytes = StringCompressionUtil.unpackAndDecompress(compressedChars);
        try {
            return new String(utf8bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

