/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.store.Chain;
import org.terracotta.entity.EntityResponse;

public abstract class EhcacheEntityResponse
implements EntityResponse {
    public abstract Type getType();

    public static HashInvalidationDone hashInvalidationDone(String cacheId, long key) {
        return new HashInvalidationDone(cacheId, key);
    }

    public static AllInvalidationDone allInvalidationDone(String cacheId) {
        return new AllInvalidationDone(cacheId);
    }

    public static ServerInvalidateHash serverInvalidateHash(String cacheId, long key) {
        return new ServerInvalidateHash(cacheId, key);
    }

    public static ClientInvalidateHash clientInvalidateHash(String cacheId, long key, int invalidationId) {
        return new ClientInvalidateHash(cacheId, key, invalidationId);
    }

    public static ClientInvalidateAll clientInvalidateAll(String cacheId, int invalidationId) {
        return new ClientInvalidateAll(cacheId, invalidationId);
    }

    public static MapValue mapValue(Object value) {
        return new MapValue(value);
    }

    public static class MapValue
    extends EhcacheEntityResponse {
        private final Object value;

        public MapValue(Object value) {
            this.value = value;
        }

        @Override
        public Type getType() {
            return Type.MAP_VALUE;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class ClientInvalidateAll
    extends EhcacheEntityResponse {
        private final String cacheId;
        private final int invalidationId;

        public ClientInvalidateAll(String cacheId, int invalidationId) {
            this.cacheId = cacheId;
            this.invalidationId = invalidationId;
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public Type getType() {
            return Type.CLIENT_INVALIDATE_ALL;
        }
    }

    public static class ClientInvalidateHash
    extends EhcacheEntityResponse {
        private final String cacheId;
        private final long key;
        private final int invalidationId;

        public ClientInvalidateHash(String cacheId, long key, int invalidationId) {
            this.cacheId = cacheId;
            this.key = key;
            this.invalidationId = invalidationId;
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public long getKey() {
            return this.key;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public Type getType() {
            return Type.CLIENT_INVALIDATE_HASH;
        }
    }

    public static class ServerInvalidateHash
    extends EhcacheEntityResponse {
        private final String cacheId;
        private final long key;

        public ServerInvalidateHash(String cacheId, long key) {
            this.cacheId = cacheId;
            this.key = key;
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public Type getType() {
            return Type.SERVER_INVALIDATE_HASH;
        }
    }

    public static class AllInvalidationDone
    extends EhcacheEntityResponse {
        private final String cacheId;

        AllInvalidationDone(String cacheId) {
            this.cacheId = cacheId;
        }

        public String getCacheId() {
            return this.cacheId;
        }

        @Override
        public Type getType() {
            return Type.ALL_INVALIDATION_DONE;
        }
    }

    public static class HashInvalidationDone
    extends EhcacheEntityResponse {
        private final String cacheId;
        private final long key;

        HashInvalidationDone(String cacheId, long key) {
            this.cacheId = cacheId;
            this.key = key;
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public Type getType() {
            return Type.HASH_INVALIDATION_DONE;
        }
    }

    public static class GetResponse
    extends EhcacheEntityResponse {
        private final Chain chain;

        GetResponse(Chain chain) {
            this.chain = chain;
        }

        @Override
        public Type getType() {
            return Type.GET_RESPONSE;
        }

        public Chain getChain() {
            return this.chain;
        }
    }

    public static class Failure
    extends EhcacheEntityResponse {
        private final ClusterException cause;

        Failure(ClusterException cause) {
            this.cause = cause;
        }

        @Override
        public Type getType() {
            return Type.FAILURE;
        }

        public ClusterException getCause() {
            return this.cause;
        }
    }

    public static class Success
    extends EhcacheEntityResponse {
        public static final Success INSTANCE = new Success();

        private Success() {
        }

        @Override
        public Type getType() {
            return Type.SUCCESS;
        }
    }

    public static enum Type {
        SUCCESS(0),
        FAILURE(1),
        GET_RESPONSE(2),
        HASH_INVALIDATION_DONE(3),
        ALL_INVALIDATION_DONE(4),
        CLIENT_INVALIDATE_HASH(5),
        CLIENT_INVALIDATE_ALL(6),
        SERVER_INVALIDATE_HASH(7),
        MAP_VALUE(8);

        private final byte opCode;

        private Type(byte opCode) {
            this.opCode = opCode;
        }

        public byte getOpCode() {
            return this.opCode;
        }

        public static Type responseType(byte opCode) {
            switch (opCode) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return FAILURE;
                }
                case 2: {
                    return GET_RESPONSE;
                }
                case 3: {
                    return HASH_INVALIDATION_DONE;
                }
                case 4: {
                    return ALL_INVALIDATION_DONE;
                }
                case 5: {
                    return CLIENT_INVALIDATE_HASH;
                }
                case 6: {
                    return CLIENT_INVALIDATE_ALL;
                }
                case 7: {
                    return SERVER_INVALIDATE_HASH;
                }
                case 8: {
                    return MAP_VALUE;
                }
            }
            throw new IllegalArgumentException("Store operation not defined for : " + opCode);
        }
    }
}

