/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.service.ClusteredMapException;
import org.ehcache.clustered.client.internal.service.ValueCodec;
import org.ehcache.clustered.client.internal.service.ValueCodecFactory;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.StateRepositoryMessageFactory;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;

public class ConcurrentClusteredMap<K, V>
implements ConcurrentMap<K, V> {
    private final StateRepositoryMessageFactory messageFactory;
    private final EhcacheClientEntity entity;
    private final Class<K> keyClass;
    private final ValueCodec<K> keyCodec;
    private final ValueCodec<V> valueCodec;

    public ConcurrentClusteredMap(String cacheId, String mapId, EhcacheClientEntity entity, Class<K> keyClass, Class<V> valueClass) {
        this.keyClass = keyClass;
        this.keyCodec = ValueCodecFactory.getCodecForClass(keyClass);
        this.valueCodec = ValueCodecFactory.getCodecForClass(valueClass);
        this.messageFactory = new StateRepositoryMessageFactory(cacheId, mapId);
        this.entity = entity;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public V get(Object key) {
        if (!this.keyClass.isAssignableFrom(key.getClass())) {
            return null;
        }
        Object response = this.getResponse(this.messageFactory.getMessage(this.keyCodec.encode(key)));
        return this.valueCodec.decode(response);
    }

    private Object getResponse(StateRepositoryOpMessage message) {
        try {
            EhcacheEntityResponse response = this.entity.invoke(message, true);
            return ((EhcacheEntityResponse.MapValue)response).getValue();
        }
        catch (ClusterException ce) {
            throw new ClusteredMapException(ce);
        }
        catch (TimeoutException te) {
            throw new ClusteredMapException(te);
        }
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set response = (Set)this.getResponse(this.messageFactory.entrySetMessage());
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry objectEntry : response) {
            entries.add(new AbstractMap.SimpleEntry<K, V>(this.keyCodec.decode(objectEntry.getKey()), this.valueCodec.decode(objectEntry.getValue())));
        }
        return entries;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object response = this.getResponse(this.messageFactory.putIfAbsentMessage(this.keyCodec.encode(key), this.valueCodec.encode(value)));
        return this.valueCodec.decode(response);
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException("TODO");
    }
}

