/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.io.Serializable;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;

public abstract class LifecycleMessage
extends EhcacheEntityMessage
implements Serializable {
    @Override
    public byte getOpCode() {
        return this.getType().getCode();
    }

    @Override
    public EhcacheEntityMessage.Type getType() {
        return EhcacheEntityMessage.Type.LIFECYCLE_OP;
    }

    public abstract LifeCycleOp operation();

    @Override
    public String toString() {
        return (Object)((Object)this.getType()) + "#" + (Object)((Object)this.operation());
    }

    public static class DestroyServerStore
    extends LifecycleMessage {
        private static final long serialVersionUID = -1772028546913171535L;
        private final String name;

        DestroyServerStore(String name) {
            this.name = name;
        }

        @Override
        public LifeCycleOp operation() {
            return LifeCycleOp.DESTROY_SERVER_STORE;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ReleaseServerStore
    extends LifecycleMessage {
        private static final long serialVersionUID = 6486779694089287953L;
        private final String name;

        ReleaseServerStore(String name) {
            this.name = name;
        }

        @Override
        public LifeCycleOp operation() {
            return LifeCycleOp.RELEASE_SERVER_STORE;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ValidateServerStore
    extends BaseServerStore {
        private static final long serialVersionUID = 8762670006846832185L;

        ValidateServerStore(String name, ServerStoreConfiguration storeConfiguration) {
            super(name, storeConfiguration);
        }

        @Override
        public LifeCycleOp operation() {
            return LifeCycleOp.VALIDATE_SERVER_STORE;
        }
    }

    public static class CreateServerStore
    extends BaseServerStore {
        private static final long serialVersionUID = -5832725455629624613L;

        CreateServerStore(String name, ServerStoreConfiguration storeConfiguration) {
            super(name, storeConfiguration);
        }

        @Override
        public LifeCycleOp operation() {
            return LifeCycleOp.CREATE_SERVER_STORE;
        }
    }

    public static abstract class BaseServerStore
    extends LifecycleMessage {
        private static final long serialVersionUID = 4879477027919589726L;
        private final String name;
        private final ServerStoreConfiguration storeConfiguration;

        protected BaseServerStore(String name, ServerStoreConfiguration storeConfiguration) {
            this.name = name;
            this.storeConfiguration = storeConfiguration;
        }

        public String getName() {
            return this.name;
        }

        public ServerStoreConfiguration getStoreConfiguration() {
            return this.storeConfiguration;
        }
    }

    public static class ConfigureStoreManager
    extends LifecycleMessage {
        private static final long serialVersionUID = 730771302294202898L;
        private final ServerSideConfiguration configuration;

        ConfigureStoreManager(ServerSideConfiguration config) {
            this.configuration = config;
        }

        @Override
        public LifeCycleOp operation() {
            return LifeCycleOp.CONFIGURE;
        }

        public ServerSideConfiguration getConfiguration() {
            return this.configuration;
        }
    }

    public static class ValidateStoreManager
    extends LifecycleMessage {
        private static final long serialVersionUID = 5742152283115139745L;
        private final ServerSideConfiguration configuration;

        ValidateStoreManager(ServerSideConfiguration config) {
            this.configuration = config;
        }

        @Override
        public LifeCycleOp operation() {
            return LifeCycleOp.VALIDATE;
        }

        public ServerSideConfiguration getConfiguration() {
            return this.configuration;
        }
    }

    public static enum LifeCycleOp {
        CONFIGURE,
        VALIDATE,
        CREATE_SERVER_STORE,
        VALIDATE_SERVER_STORE,
        RELEASE_SERVER_STORE,
        DESTROY_SERVER_STORE;

    }
}

