/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityMessage;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityUserException;

public class VoltronEntityAppliedResponseImpl
extends DSOMessageBase
implements VoltronEntityAppliedResponse {
    private TransactionID transactionID;
    private boolean isSuccess;
    private boolean isRetire;
    private byte[] successResponse;
    private EntityException failureException;

    @Override
    public VoltronEntityMessage.Acks getAckType() {
        return VoltronEntityMessage.Acks.APPLIED;
    }

    @Override
    public void setSuccess(TransactionID transactionID, byte[] response, boolean retire) {
        Assert.assertNull(this.transactionID);
        Assert.assertNull(this.successResponse);
        Assert.assertNull(this.failureException);
        Assert.assertNotNull(transactionID);
        Assert.assertNotNull(response);
        this.transactionID = transactionID;
        this.isSuccess = true;
        this.isRetire = retire;
        this.successResponse = response;
    }

    @Override
    public void setFailure(TransactionID transactionID, EntityException exception, boolean retire) {
        Assert.assertNull(this.transactionID);
        Assert.assertNull(this.successResponse);
        Assert.assertNull(this.failureException);
        Assert.assertNotNull(transactionID);
        Assert.assertNotNull(exception);
        this.transactionID = transactionID;
        this.isSuccess = false;
        this.isRetire = retire;
        this.failureException = exception;
    }

    public VoltronEntityAppliedResponseImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public VoltronEntityAppliedResponseImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outputStream = this.getOutputStream();
        this.putNVPair((byte)0, (byte)0);
        outputStream.writeLong(this.transactionID.toLong());
        outputStream.writeBoolean(this.isSuccess);
        outputStream.writeBoolean(this.isRetire);
        if (this.isSuccess) {
            Assert.assertNotNull(this.successResponse);
            outputStream.writeInt(this.successResponse.length);
            outputStream.write(this.successResponse);
        } else {
            Assert.assertNotNull(this.failureException);
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);
                try {
                    objectOutput.writeObject(this.failureException);
                }
                finally {
                    objectOutput.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            byte[] serializedException = byteOutput.toByteArray();
            outputStream.writeInt(serializedException.length);
            outputStream.write(serializedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        Assert.assertTrue(0 == name);
        Assert.assertTrue(null == this.transactionID);
        this.getByteValue();
        this.transactionID = new TransactionID(this.getLongValue());
        this.isSuccess = this.getBooleanValue();
        this.isRetire = this.getBooleanValue();
        if (this.isSuccess) {
            this.successResponse = this.getBytesArray();
        } else {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(this.getBytesArray());
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            try {
                this.failureException = (EntityException)objectInput.readObject();
            }
            catch (ClassNotFoundException e) {
                this.failureException = new EntityUserException(null, null, e);
            }
            finally {
                objectInput.close();
            }
        }
        return true;
    }

    @Override
    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    @Override
    public byte[] getSuccessValue() {
        return this.successResponse;
    }

    @Override
    public EntityException getFailureException() {
        return this.failureException;
    }

    @Override
    public boolean alsoRetire() {
        return this.isRetire;
    }
}

